package com.kingdee.eas.xr.helper;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JFileChooser;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;

public class EASExcelHelper {
	
	public static String showExcelSelectDlg(CoreUIObject ui) {
		KDFileChooser chsFile = new KDFileChooser();
		String XLS = "xls";
		String Key_File = "Key_File";
		SimpleFileFilter Filter_Excel = new SimpleFileFilter(XLS, "MS Excel" + LanguageManager.getLangMessage(Key_File, WizzardIO.class, "����ʧ��"));
		chsFile.addChoosableFileFilter(Filter_Excel);
		int ret = chsFile.showOpenDialog(ui);
		if (ret != JFileChooser.APPROVE_OPTION)
			SysUtil.abort();
		File file = chsFile.getSelectedFile();
		String fileName = file.getAbsolutePath();
		return fileName;
	}
	
	public static int importExcelToTable2(String fileName, KDTable table, int headRowCount, int keyColumnCount) throws Exception {
		KDSBook kdsbook = null;
		try {
			kdsbook = POIXlsReader.parse2(fileName);
		} catch (Exception e) {
			e.printStackTrace();
			MsgBox.showError("!");
			SysUtil.abort();
		}
		if (kdsbook == null) {
			SysUtil.abort();
		}
		KDSSheet excelSheet = kdsbook.getSheet(new Integer(0));
		Map colNameMap = new HashMap();
		int maxRow = excelSheet.getRowCount();
		int maxColumn = excelSheet.getColumnCount();
		for (int col = 0; col < maxColumn; col++) {
			String excelColName = excelSheet.getCell(0, col, true).getText();
			colNameMap.put(excelColName, new Integer(col));
		}
		int successCount = 0;
		for (int rowIndex = headRowCount; rowIndex < maxRow; rowIndex++) {
			IRow row = table.addRow();
			String key = "";
			int totalKeyCount = 0;
			int count = 0;
			for (int i = 0; i < table.getColumnCount(); i++) {
				if (count >= keyColumnCount) {
					break;
				}
				totalKeyCount++;
				if (table.getColumn(i).getStyleAttributes().isHided()) {
					continue;
				}
				String colName = (String) table.getHeadRow(0).getCell(i).getValue();
				if(colName==null || "".equals(colName))
					break;
				Integer colInt = (Integer) colNameMap.get(colName);
				if (colInt == null) {
					continue;
//					MsgBox.showError(colName + "Ϊ!");
//					SysUtil.abort();
				}
				String text = excelSheet.getCell(rowIndex, colInt.intValue(), true).getText();
				if (!StringUtils.isEmpty(text)) {
					key += text;
					row.getCell(i).setValue(text);
				}
				count++;
			}
			successCount++;
//			IRow row = getRowByRoomKey(table, key, keyColumnCount);
//			if (row == null) {
//				continue;
//			}
//			for (int i = totalKeyCount; i < table.getColumnCount(); i++) {
//				ICell tblCell = row.getCell(i);
//				if (tblCell == null || tblCell.getStyleAttributes().isLocked())
//					continue;
//				String colName = (String) table.getHeadRow(0).getCell(i).getValue();
//				Integer colInt = (Integer) colNameMap.get(colName);
//				if (colInt == null) {
//					continue;
//				}
//				Object cellRawVal = excelSheet.getCell(rowIndex, colInt.intValue(), true).getValue();
//				if (cellRawVal == null || cellRawVal == "") {
//					continue;
//				}
//				tblCell.setValue(FDCHelper.toBigDecimal(cellRawVal));
//			}
		}
		return successCount;
	}
	private static IRow getRowByRoomKey(KDTable table, String key, int keyColumnCount) {
		for (int i = 0; i < table.getRowCount(); i++) {
			IRow row = table.getRow(i);
			String aKey = "";
			int count = 0;
			for (int j = 0; j < table.getColumnCount(); j++) {
				if (count >= keyColumnCount) {
					break;
				}
				if (table.getColumn(j).getStyleAttributes().isHided()) {
					continue;
				}
				Object value = row.getCell(j).getValue();
				if (value != null) {
					aKey += value.toString();
				}
				count++;
			}
			if (aKey.equals(key)) {
				return row;
			}
		}
		return null;
	}
}
