/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.awt.event.*;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.custom.gggl.DTypeEnum;
import com.kingdee.eas.framework.*;

/**
 * output class name
 */
public class SchedulBillListUI extends AbstractSchedulBillListUI
{
    private static final Logger logger = CoreUIObject.getLogger(SchedulBillListUI.class);
    
    /**
     * output class constructor
     */
    public SchedulBillListUI() throws Exception
    {
        super();
    }
    public void onLoad() throws Exception {
    	super.onLoad();
    	actionMultiSubmit.setVisible(false);
    	actionAddNew.setVisible(false);
    	this.setUITitle("ڹ");
    }
    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0,EntityViewInfo arg1) {
		
		 CompanyOrgUnitInfo info= SysContext.getSysContext().getCurrentFIUnit();
	    	EntityViewInfo view = (EntityViewInfo)arg1.clone();
			FilterInfo filInfo = new FilterInfo();
			filInfo.getFilterItems().add(new FilterItemInfo("djType",DTypeEnum.GG_VALUE));
			filInfo.getFilterItems().add(new FilterItemInfo("company.longNumber",info.getLongNumber()+"%",CompareType.LIKE));
			try {
				view.getFilter().mergeFilter(filInfo, "and");
			} catch (BOSException e) {
				e.printStackTrace();
			}
		return super.getQueryExecutor(arg0, view);
	}
    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }

    /**
     * output tblMain_tableClicked method
     */
    protected void tblMain_tableClicked(com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent e) throws Exception
    {
        super.tblMain_tableClicked(e);
    }

    /**
     * output tblMain_tableSelectChanged method
     */
    protected void tblMain_tableSelectChanged(com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent e) throws Exception
    {
        super.tblMain_tableSelectChanged(e);
    }

  
    /**
     * output actionAudit_actionPerformed
     */
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAudit_actionPerformed(e);
        refreshList();
    }

    /**
     * output actionUnAudit_actionPerformed
     */
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionUnAudit_actionPerformed(e);
        refreshList();
    }


    /**
     * output getBizInterface method
     */
    protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception
    {
        return com.kingdee.eas.custom.gggl.SchedulBillFactory.getRemoteInstance();
    }

    /**
     * output createNewData method
     */
    protected com.kingdee.bos.dao.IObjectValue createNewData()
    {
        com.kingdee.eas.custom.gggl.SchedulBillInfo objectValue = new com.kingdee.eas.custom.gggl.SchedulBillInfo();
		
        return objectValue;
    }

	public void actionMultiSubmit_actionPerformed(ActionEvent e)
			throws Exception {
		// TODO Auto-generated method stub
		
	}

}