/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.awt.event.*;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.log4j.Logger;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.custom.gggl.AdvertInfo;
import com.kingdee.eas.custom.gggl.ContractChangeE1Collection;
import com.kingdee.eas.custom.gggl.ContractChangeE1Factory;
import com.kingdee.eas.custom.gggl.ContractChangeE1Info;
import com.kingdee.eas.custom.gggl.DTypeEnum;
import com.kingdee.eas.custom.gggl.Hyhelper;
import com.kingdee.eas.custom.gggl.ReceTypeInfo;
import com.kingdee.eas.custom.gggl.SaleContractE1Collection;
import com.kingdee.eas.custom.gggl.SaleContractE1Factory;
import com.kingdee.eas.custom.gggl.SaleContractE1Info;
import com.kingdee.eas.framework.*;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.xr.helper.DateDaySub;
import com.kingdee.eas.xr.helper.PersonXRHelper;
import com.kingdee.eas.xr.helper.TableXRHelper;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;

/**
 * output class name
 */
public class ContractChangeEditUI extends AbstractContractChangeEditUI
{
	private static final Logger logger = CoreUIObject.getLogger(ContractChangeEditUI.class);

	/**
	 * output class constructor
	 */
	public ContractChangeEditUI() throws Exception
	{
		super();
	}
	//ע⣺༭ Ժ ¼  kdtE1  kdtE2  λֶ  չұ Ľע ҪȻ˲. Ĵ 
//	kdtE2_ggw_PromptBox.addSelectorListener(new SelectorListener() {
//	com.kingdee.eas.custom.gggl.client.AdvertListUI kdtE2_ggw_PromptBox_F7ListUI = null;
//	public void willShow(SelectorEvent e) {
//		if (kdtE2_ggw_PromptBox_F7ListUI == null) {
//			try {
//				kdtE2_ggw_PromptBox_F7ListUI = new com.kingdee.eas.custom.gggl.client.AdvertListUI();
//			} catch (Exception e1) {
//				e1.printStackTrace();
//			}
//			HashMap ctx = new HashMap();
//			ctx.put("bizUIOwner",javax.swing.SwingUtilities.getWindowAncestor(kdtE2_ggw_PromptBox_F7ListUI));
//			kdtE2_ggw_PromptBox_F7ListUI.setF7Use(true,ctx);
//			kdtE2_ggw_PromptBox.setSelector(kdtE2_ggw_PromptBox_F7ListUI);
//		}
//	}
//});
	
	public void loadFields()
	{
		super.loadFields();
		//ڲ¼
		kdtE1.getColumn("zlzq").getStyleAttributes().setLocked(true);
		kdtE1.getColumn("sourceEnID").getStyleAttributes().setHided(true);
		kdtE2.getColumn("sourceEnID").getStyleAttributes().setHided(true);
		kdtE1.getColumn("seq").getStyleAttributes().setHided(true);
		kdtE2.getColumn("seq").getStyleAttributes().setHided(true);
		
	}
	@Override
	public void onLoad() throws Exception {
		super.onLoad();
//		 setPreferredSize(getMaximumSize());
		
		//ͥ
		if(djType.getSelectedItem()!=null &&  djType.getSelectedItem()==DTypeEnum.zt){
			
	    	EntityViewInfo view = new EntityViewInfo();
			FilterInfo filInfo = new FilterInfo();
			filInfo.getFilterItems().add(new FilterItemInfo("treeid.id","JQcAAAAAgOrsyXfw" ,CompareType.EQUALS));//idǹλ Ӧͥ
			view.setFilter(filInfo);
			KDBizPromptBox bizBox = (KDBizPromptBox) kdtE1.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox.setEntityViewInfo(view);
			
			KDBizPromptBox bizBox2 = (KDBizPromptBox) kdtE2.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox2.setEntityViewInfo(view);
		}
		
		//
		if( djType.getSelectedItem()!=null &&  djType.getSelectedItem()==DTypeEnum.gg){
			
	    	EntityViewInfo view = new EntityViewInfo();
			FilterInfo filInfo = new FilterInfo();
			filInfo.getFilterItems().add(new FilterItemInfo("treeid.id","JQcAAAAAgOrsyXfw" ,CompareType.NOTEQUALS));//idǹλ Ӧͥ
			view.setFilter(filInfo);
			KDBizPromptBox bizBox = (KDBizPromptBox) kdtE1.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox.setEntityViewInfo(view);
			
			KDBizPromptBox bizBox2 = (KDBizPromptBox) kdtE2.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox2.setEntityViewInfo(view);
		}
		 TableXRHelper.getFootRow(kdtE1, new String[]{"zlAmount","zzAmount"});    /*¼ϼ*/
		 TableXRHelper.getFootRow(kdtE2, new String[]{"skAmount"});    /*¼ϼ*/
	}
	
	
	
	
	protected void btnGgPq_actionPerformed(ActionEvent e) throws Exception {
		super.btnGgPq_actionPerformed(e);

		KDPanel PanelName=(KDPanel) kDTabbedPane1.getSelectedComponent();
    	if(PanelName.equals(kDPanel1)){

		if(kdtE1.getSelectManager().getActiveRowIndex()==-1){
			MsgBox.showConfirm2("ѡӦУ");
			SysUtil.abort();
		}
		int row=kdtE1.getSelectManager().getActiveRowIndex();
		if(kdtE1.getCell(row, "ggw").getValue()!=null){
			UIContext  context = new UIContext(this);
			String ggname=kdtE1.getCell(row, "ggw").getValue().toString();
			context.put("ggname", ggname);

			if(djType.getSelectedItem()==DTypeEnum.zt){
				IUIWindow create = UIFactory.createUIFactory(UIFactoryName.NEWWIN).create(AdvertManUI.class.getName(),context,null,OprtState.VIEW);
				create.show();
			}
			
			if(djType.getSelectedItem()==DTypeEnum.gg){
				IUIWindow create = UIFactory.createUIFactory(UIFactoryName.NEWWIN).create(AdvertGuangGaoPaiQiUI.class.getName(),context,null,OprtState.VIEW);
				create.show();
			}
		
		}else{
			MsgBox.showConfirm2("ѡУӦĹλΪգ");
			SysUtil.abort();
		}
    }


    	if(PanelName.equals(kDPanel2)){
    		if(kdtE2.getSelectManager().getActiveRowIndex()==-1){
    			MsgBox.showConfirm2("ѡӦУ");
    			SysUtil.abort();
    		}
    		int row=kdtE2.getSelectManager().getActiveRowIndex();
    		if(kdtE2.getCell(row, "ggw").getValue()!=null){
    			UIContext  context = new UIContext(this);
    			String ggname=kdtE2.getCell(row, "ggw").getValue().toString();
    			context.put("ggname", ggname);

    			if(djType.getSelectedItem()==DTypeEnum.zt){
    				IUIWindow create = UIFactory.createUIFactory(UIFactoryName.MODEL).create(AdvertManUI.class.getName(),context,null,OprtState.VIEW);
    				create.show();
    			}
    			
    			if(djType.getSelectedItem()==DTypeEnum.gg){
    				IUIWindow create = UIFactory.createUIFactory(UIFactoryName.MODEL).create(AdvertGuangGaoPaiQiUI.class.getName(),context,null,OprtState.VIEW);
    				create.show();
    			}
    		
    		}else{
    			MsgBox.showConfirm2("ѡУӦĹλΪգ");
    			SysUtil.abort();
    		}
        }
	
	}

	/**
	 * output storeFields method
	 */
	public void storeFields()
	{
		super.storeFields();
	}


	/**
	 * output actionSave_actionPerformed
	 */
	public void actionSave_actionPerformed(ActionEvent e) throws Exception
	{

		super.actionSave_actionPerformed(e);
	}


	/**
	 * output actionAudit_actionPerformed
	 */
	public void actionAudit_actionPerformed(ActionEvent e) throws Exception
	{
		super.actionAudit_actionPerformed(e);
	}

	/**
	 * output actionUnAudit_actionPerformed
	 */
	public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception
	{
		super.actionUnAudit_actionPerformed(e);
	}

	/**
	 * output getBizInterface method
	 */
	protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception
	{
		return com.kingdee.eas.custom.gggl.ContractChangeFactory.getRemoteInstance();
	}

	/**
	 * output createNewDetailData method
	 */
	protected IObjectValue createNewDetailData(KDTable table)
	{

		return null;
	}

	/**
	 * output createNewData method
	 */
	protected com.kingdee.bos.dao.IObjectValue createNewData()
	{
		com.kingdee.eas.custom.gggl.ContractChangeInfo objectValue = new com.kingdee.eas.custom.gggl.ContractChangeInfo();
		objectValue.setCreator((com.kingdee.eas.base.permission.UserInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentUser()));
		objectValue.setBizDate(new Date());

		CompanyOrgUnitInfo info= SysContext.getSysContext().getCurrentFIUnit();
		if(SysContext.getSysContext().getCurrentUserInfo()!=null){
			PersonInfo uinf0= SysContext.getSysContext().getCurrentUserInfo().getPersonId();
			objectValue.setZrPerson(uinf0);
			objectValue.setCompany(info);
			objectValue.setDeparment(PersonXRHelper.getPosiMemByDeptUser(uinf0));
		}
		return objectValue;
	}
	protected void attachListeners() {

	}
	protected void detachListeners() {

	}
	protected KDTextField getNumberCtrl() {
		return null;
	}
	protected void verifyInputForSave() throws Exception {
	}
	protected void verifyInputForSubmit() throws Exception {

		 BigDecimal zlAmount1= UIRuleUtil.getBigDecimal(UIRuleUtil.sum(kdtE1,"zlAmount"));
		 BigDecimal zzAmount1= UIRuleUtil.getBigDecimal(UIRuleUtil.sum(kdtE1,"zzAmount"));
		 BigDecimal zlAmount=BigDecimal.ZERO;
		 BigDecimal zzAmount=BigDecimal.ZERO;
		 
		 for(int i=0;i<kdtE2.getRowCount();i++){
			 ReceTypeInfo info= (ReceTypeInfo) kdtE2.getCell(i, "recType").getValue();
			 if(info.getNumber().equals("001")){
			   BigDecimal skAmount=  UIRuleUtil.getBigDecimal(kdtE2.getCell(i, "skAmount").getValue());
			   zlAmount=zlAmount.add(skAmount);
			 }
			 if(info.getNumber().equals("002")){
			  BigDecimal skAmount=  UIRuleUtil.getBigDecimal(kdtE2.getCell(i, "skAmount").getValue());
			  zzAmount=zzAmount.add(skAmount);
			}
		 }
		 if(zlAmount1.compareTo(zlAmount)!=0){
				MsgBox.showWarning("޽"+zlAmount1+"տƻ޷:"+zlAmount+"һ£");
				SysUtil.abort();
		 }
		 if(zzAmount1.compareTo(zzAmount)!=0){
				MsgBox.showWarning("ѣ"+zzAmount1+"տƻ:"+zzAmount+"һ£");
				SysUtil.abort();
		 }
	}

	  
    protected void verifyInput(ActionEvent e) throws Exception {
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtcontractNum.getValue())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ͬ/"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtcompany.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"˾"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtcustomer.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ͻ"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(txthtAmount.getValue())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ͬ˰"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtzrPerson.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {""});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtdeparment.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"β"});
		}
//		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(txtbeiz.getText())) {
//			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ע"});
//		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"ggw").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"λ"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlStartDate").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ʼ"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlEndDate").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"޵"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlzq").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"/"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlAmount").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"޷"});
			}
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(txtpp.getText())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"Ʒ"});
		}

		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(zhlx.getSelectedItem())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"⻧/⻧"});
		}
		int e1=kdtE1.getRowCount();
		int e2=kdtE2.getRowCount();
		if(e1<1 || e2<1){
			MsgBox.showWarning("Ϣտƻһ¼");
			SysUtil.abort();
		}
    	
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		for (int i = 0; i < kdtE1.getRowCount(); i++) {
			if(kdtE1.getCell(i, "ggw").getValue()!=null && kdtE1.getCell(i, "zlStartDate").getValue()!=null){
			AdvertInfo advertInfo=(AdvertInfo) kdtE1.getCell(i, "ggw").getValue();
			Date zlStartDate=(Date) kdtE1.getCell(i, "zlStartDate").getValue();
			String  zlStartDates=  sdf.format(zlStartDate);
			if(!"JQcAAAAAgOnsyXfw".equals(advertInfo.getTreeid().getId().toString())){
				 boolean  flag=	Hyhelper.isGgwCheck(editData.getId(), editData.getContractNum().getId(), advertInfo.getId().toString(), zlStartDates);
	             if(flag){
	            		MsgBox.showWarning("λ("+advertInfo.getName()+") :޿ʼͬظڣѡ");
						SysUtil.abort();
	             	}
				}
			}
		}
	}
	
	
	@Override
	protected void initWorkButton() {
		actionAddNew.setVisible(false);
		actionCopy.setVisible(false);
		actionAttachment.setVisible(false);
		actionPrint.setVisible(false);
		actionPrintPreview.setVisible(false);
		actionCreateFrom.setVisible(false);
		actionAddLine.setVisible(false);
		actionInsertLine.setVisible(false);
		actionRemoveLine.setVisible(false);
		super.initWorkButton();
	}
	@Override
	protected void kdtE1_editStopped(KDTEditEvent e) throws Exception {
		int rowIndex = e.getRowIndex();
		int colIndex = e.getColIndex();
		String fieldName = this.kdtE1.getColumnKey(colIndex);
		if ("zlStartDate".equalsIgnoreCase(fieldName)||"zlEndDate".equalsIgnoreCase(fieldName)) {
			if(this.kdtE1.getCell(rowIndex, "zlStartDate").getValue()!=null&&this.kdtE1.getCell(rowIndex, "zlEndDate").getValue()!=null){
				Date  	zlStartDate=(Date) this.kdtE1.getCell(rowIndex, "zlStartDate").getValue();
				Date  	zlEndDate=(Date) this.kdtE1.getCell(rowIndex, "zlEndDate").getValue();
				if(zlEndDate.getTime()<zlStartDate.getTime()){
					this.kdtE1.getCell(rowIndex, "zlEndDate").setValue(null);
					MsgBox.showWarning("޵ڲСڿʼڣ");
					SysUtil.abort();
				}
			}
		}
		super.kdtE1_editStopped(e);

		if ("zlAmount".equalsIgnoreCase(fieldName)||"zzAmount".equalsIgnoreCase(fieldName)) {

			txthtAmount.setValue(UIRuleUtil.getBigDecimal(UIRuleUtil.sum(kdtE1,"zlAmount")).add(UIRuleUtil.getBigDecimal(UIRuleUtil.sum(kdtE1,"zzAmount"))));

		}
		//int rowIndex = e.getRowIndex();
		//  int colIndex = e.getColIndex();
		//   String fieldName = this.kdtE1.getColumnKey(colIndex);
		if ("zlStartDate".equalsIgnoreCase(fieldName)||"zlEndDate".equalsIgnoreCase(fieldName)) {
			if(this.kdtE1.getCell(rowIndex, "zlStartDate").getValue()!=null&&this.kdtE1.getCell(rowIndex, "zlEndDate").getValue()!=null){
				Date  	zlStartDate=(Date) this.kdtE1.getCell(rowIndex, "zlStartDate").getValue();
				Date  	zlEndDate=(Date) this.kdtE1.getCell(rowIndex, "zlEndDate").getValue();
				Calendar c = Calendar.getInstance();       
				c.setTime(zlEndDate);       
				c.add(Calendar.DAY_OF_MONTH,1);//+1
				Date zlEndDate2 = c.getTime();
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				String  zlStartDates=  sdf.format(zlStartDate);
				String  zlEndDates=  sdf.format(zlEndDate2);
				String mmdd=	DateDaySub.remainDateToString(zlStartDates, zlEndDates);
				this.kdtE1.getCell(rowIndex, "zlzq").setValue(mmdd);

			}
		}
	}
	
	Set set = new HashSet();
	protected void kDPanel2_componentShown(ComponentEvent e) throws Exception {
		super.kDPanel2_componentShown(e);
		if(kdtE1.getRowCount()==0 ){
			MsgBox.showConfirm2("ϢУ");
			SysUtil.abort();
		}
		AdvertInfo info=null;
		for(int i =0;i<kdtE1.getRowCount();i++){
			IRow rowE1=kdtE1.getRow(i);
			if(rowE1.getCell("ggw").getValue()==null){
				int j=i+1;
				MsgBox.showConfirm2("һ¼Уڣ"+j+" жӦ λΪգ");
				SysUtil.abort();
			}
			
			info=(AdvertInfo)rowE1.getCell("ggw").getValue();
			String ggwid= info.getId().toString();
			set.add(ggwid);
		}
		
		if(info != null) {
			EntityViewInfo evi = new EntityViewInfo();
			FilterInfo filter = new FilterInfo();
			filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
			evi.setFilter(filter);
			KDBizPromptBox bizBox2 = (KDBizPromptBox) kdtE2.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox2.setEntityViewInfo(evi);
		}
	}
	

}