package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.gggl.ISaleContractE2;
import com.kingdee.eas.custom.gggl.SaleContractE2Factory;
import com.kingdee.eas.custom.gggl.SaleContractE2Info;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;

public class OtherBillControllerBeanEx extends OtherBillControllerBean {
	
	public void audit(Context ctx, IObjectPK billId) throws BOSException,
			EASBizException {
		super.audit(ctx, billId);
		OtherBillInfo info =OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo(billId);
		if(info.get("saleContract")!=null&&!info.getBoolean("isHy")){//ͬͨдǷӦ
			ISaleContractE2 iSaleContractE2=SaleContractE2Factory.getLocalInstance(ctx);
			for(int i=0;i<info.getEntry().size();i++){
				OtherBillentryInfo enInfo=info.getEntry().get(i);
				if(enInfo.getCoreBillEntryId()!=null){
					SaleContractE2Info sEnInfo =iSaleContractE2.getSaleContractE2Info(new ObjectUuidPK(enInfo.getCoreBillEntryId()));
					sEnInfo.setIsYs(true);
					iSaleContractE2.update(new ObjectUuidPK(enInfo.getCoreBillEntryId()), sEnInfo);
				}
			}
		}

	}
	public void unAudit(Context ctx, IObjectPK pk) throws BOSException,
			EASBizException {
		super.unAudit(ctx, pk);
		OtherBillInfo info =OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo(pk);
		if(info.get("saleContract")!=null&&!info.getBoolean("isHy")){//ͬͨдǷӦ
			ISaleContractE2 iSaleContractE2=SaleContractE2Factory.getLocalInstance(ctx);
			for(int i=0;i<info.getEntry().size();i++){
				OtherBillentryInfo enInfo=info.getEntry().get(i);
				if(enInfo.getCoreBillEntryId()!=null){
					SaleContractE2Info sEnInfo =iSaleContractE2.getSaleContractE2Info(new ObjectUuidPK(enInfo.getCoreBillEntryId()));
					sEnInfo.setIsYs(false);
					iSaleContractE2.update(new ObjectUuidPK(enInfo.getCoreBillEntryId()), sEnInfo);
				}
			}
		}
	}

}
