<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/common/common.jsp"%>
<head>
<Dst:SMBase type="jquery,eui" pakgagePath="com.dst.slms.proapproval.monmarkmange.monMarkMangeEdit" uipk="monMarkMangeController" title="月度营销计划"/>
</head>
<body class="dst-mainbackground">
<div class="dst-container">

<Dst:SMMain title="月度营销计划">
	<Dst:SMEDBillToolBar >
	   <Dst:SMDGToolBar title="保存" icon="fa fa-save" bindAction="saveAction"/>
	   <Dst:SMDGToolBar title="提交并关闭" icon="fa fa-clipboard" bindAction="submitAction"/>
	   <Dst:SMDGToolBar title="查看流程图" icon="fa fa-cubes" bindAction="viewFlowAction"/>
	   <Dst:SMDGToolBar title="关闭" icon="fa fa-rotate-left" bindAction="closeAction"/>
	</Dst:SMEDBillToolBar> 
	<Dst:SMForm formid="formobj" >
		<input id="id" name="id" type="hidden" value="${model.id }">
		<div class="easyui-panel" title="月度营销计划" style="width:100%;" data-options="bodyCls:'panle-background',collapsible:true,headerCls:'panel-block-teal panel-description'">
			<div style="padding-top: 10px"></div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据编号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="number" validType="['maxLength[100]']" width="100%" value="${model.number}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">申请人</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="person" required="true" queryFieldItem="number,name" entityPath="com.dst.slms.system.entity.SysPersonInfo" width="100%" value="${model.person}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">申请人部门</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="department"  required="true" queryFieldItem="number,name" entityPath="com.dst.slms.system.entity.SysOrgInfo" width="100%" value="${model.department}"/>
					</div>
				</div>

			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">项目</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="project" readonly="true" DSTFilter="isEnable='Y'" queryFieldItem="number,name" entityPath="com.dst.slms.base.entity.MarketProjectInfo" width="100%" value="${model.project}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">总计划费用</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="totalAMT" readonly="true" precision="2" width="100%" value="${model.totalAMT}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">计划年份</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="year" dicGroupCode="year" width="100%" value="${model.year}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">所属组织</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="orgunit"  readonly="true"  queryFieldItem="number,name" entityPath="com.dst.slms.system.entity.SysOrgInfo" width="100%" value="${model.orgunit}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据状态</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="state" readonly="true" dicGroupCode="BILLSTATUS" width="100%" value="${model.state}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">计划月份</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="month" dicGroupCode="month" width="100%" value="${model.month}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">销售目标</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="xsmb"  precision="2" width="100%" value="${model.xsmb}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">费率</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="rate" precision="2" width="100%" value="${model.rate}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm12">
					<label class="dst-form-label">说明</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="remake" validType="['maxLength[100]']" width="100%" value="${model.remake}"/>
					</div>
				</div>
			</div>
		</div>	
		<div style="padding-top: 10px"></div>
		<Dst:SMEDDatagrid entityPath="com.dst.slms.proapproval.entity.MonMarkMangeE1Info" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
		ctrlSelect="true" title="营销计划" data="${model.monMarkMangeE1}" id="monMarkMangeE1" entry_editChange="E1_editChange">
			<Dst:SMEDBillToolBar id="monMarkMangeE1tb">
				<Dst:SMDGToolBar title="新增" icon="icon-entity-addline" bindAction="addRow"/>
				<Dst:SMDGToolBar title="插入" icon="icon-entity-insertline" bindAction="insRow"/>
				<Dst:SMDGToolBar title="删除" icon="icon-entity-deleteline" bindAction="removeRow"/>
				<Dst:SMDGToolBar title="上移" icon="icon-entity-upline" bindAction="moveUp"/>
				<Dst:SMDGToolBar title="下移" icon="icon-entity-downline" bindAction="moveDown"/>
			</Dst:SMEDBillToolBar>  
			<Dst:SMEDColumnMoreHeaderGroup>
				<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
				<Dst:SMEDColumnBizPromptBox field="parent" hidden="true" queryFieldItem="number,name" title="父对象关联" entityPath="com.dst.slms.proapproval.entity.MonMarkMangeInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnTextBox field="theme" required="true" title="主题" width="100"></Dst:SMEDColumnTextBox>
				<Dst:SMEDColumnTextBox field="themeDes" required="true"  title="主题描述" width="100"></Dst:SMEDColumnTextBox>
				<Dst:SMEDColumnNumberBox field="themeAmt"  hidden="true"  readonly="true" title="主题计划金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnEnumDicBox field="planType"   title="计划类型" dicGroupCode="planType" width="100"></Dst:SMEDColumnEnumDicBox>
				<Dst:SMEDColumnTextBox field="itemDes"  required="true" title="事项描述" width="100"></Dst:SMEDColumnTextBox>
				<Dst:SMEDColumnBizPromptBox field="marketAccount" DSTFilter="isLeaf='Y'" required="true"  queryFieldItem="number,name,isLeaf" title="营销科目" entityPath="com.dst.slms.base.entity.MarketAccountInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnEnumDicBox field="itemStatus"    title="事项状态" dicGroupCode="itemStatus" width="100"></Dst:SMEDColumnEnumDicBox>
				<Dst:SMEDColumnEnumDicBox field="purType"  required="true" title="采购方式" dicGroupCode="purType" width="100"></Dst:SMEDColumnEnumDicBox>
				<Dst:SMEDColumnEnumDicBox field="contractNature"  required="true" title="合同性质" dicGroupCode="contractNature" width="100"></Dst:SMEDColumnEnumDicBox>
				<Dst:SMEDColumnBizPromptBox field="contact"   queryFieldItem="number,name" title="合同编号" entityPath="com.dst.slms.contractmange.entity.SaleContractInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnCheckBox title="是否关联框架合同"  readonly="true" field="isglcontract" align="center"></Dst:SMEDColumnCheckBox>
				<Dst:SMEDColumnBizPromptBox field="supplier" queryFieldItem="number,name" title="供应商" entityPath="com.dst.slms.supplierprofile.entity.SupplierProfileInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnNumberBox field="planAmt"  required="true" title="计划金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="monAmt" title="当月使用金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="payAmt"  readonly="true" title="已支付金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnEnumDicBox field="startNote" title="开始节点" dicGroupCode="startNote" width="100"></Dst:SMEDColumnEnumDicBox>
				<Dst:SMEDColumnTextBox field="remark" title="备注" width="100"></Dst:SMEDColumnTextBox>
			</Dst:SMEDColumnMoreHeaderGroup>
		</Dst:SMEDDatagrid>
	</Dst:SMForm>	
</Dst:SMMain>
</div>
</body>
