<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/common/common.jsp"%>
<head>
<Dst:SMBase type="jquery,eui" pakgagePath="com.dst.slms.contractmange.econtermsadjust.econTermsAdjustEdit" uipk="econTermsAdjustController" title="经济条款调整单"/>
</head>
<body class="dst-mainbackground">
<div class="dst-container">

<Dst:SMMain title="经济条款调整单">
	<Dst:SMEDBillToolBar >
	   <Dst:SMDGToolBar title="保存" icon="fa fa-save" bindAction="saveAction"/>
	   <Dst:SMDGToolBar title="提交并关闭" icon="fa fa-clipboard" bindAction="submitAction"/>
	   <Dst:SMDGToolBar title="查看流程图" icon="fa fa-cubes" bindAction="viewFlowAction"/>
	   <Dst:SMDGToolBar title="关闭" icon="fa fa-rotate-left" bindAction="closeAction"/>
	</Dst:SMEDBillToolBar> 
	<Dst:SMForm formid="formobj" >
		<input id="id" name="id" type="hidden" value="${model.id }">
		<div class="easyui-panel" title="经济条款调整单<span>信息</span>" style="width:100%;" data-options="bodyCls:'panle-background',collapsible:true,headerCls:'panel-block-teal panel-description'">
			<div style="padding-top: 10px"></div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据编号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="number" required="true" validType="['maxLength[100]']" width="100%" value="${model.number}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据名称</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="name" required="true" validType="['maxLength[100]']" width="100%" value="${model.name}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">项目</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="project" readonly="true" queryFieldItem="number,name" entityPath="com.dst.slms.base.entity.MarketProjectInfo" width="100%" value="${model.project}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">合同信息</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="contract" required="true" onDataChange="contract_change" queryFieldItem="number,name" DSTFilter="state='AUDIT'" entityPath="com.dst.slms.contractmange.entity.SaleContractInfo" width="100%" value="${model.contract}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">责任部门</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="org" readonly="true" queryFieldItem="number,name" entityPath="com.dst.slms.system.entity.SysOrgInfo" width="100%" value="${model.org}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">供应商</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="supplier" readonly="true" queryFieldItem="number,name" entityPath="com.dst.slms.supplierprofile.entity.SupplierProfileInfo" width="100%" value="${model.supplier}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">合同金额</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="conAmount" readonly="true" precision="2" width="100%" value="${model.conAmount}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据状态</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="state" readonly="true" dicGroupCode="BILLSTATUS" width="100%" value="${model.state}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm12">
					<label class="dst-form-label">调整说明</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="remake" validType="['maxLength[200]']" width="100%" value="${model.remake}"/>
					</div>
				</div>
			</div>
		</div>	
		<div style="padding-top: 10px"></div>
		<Dst:SMEDDatagrid entityPath="com.dst.slms.contractmange.entity.EconTermsAdjustE1Info" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
		ctrlSelect="true" title="调整明细" data="${model.econTermsAdjustE1}" id="econTermsAdjustE1" entry_editChange="entry_change" >
			<Dst:SMEDBillToolBar id="econTermsAdjustE1tb">
				<Dst:SMDGToolBar title="新增" icon="icon-entity-addline" bindAction="addRow"/>
				<Dst:SMDGToolBar title="插入" icon="icon-entity-insertline" bindAction="insRow"/>
				<Dst:SMDGToolBar title="删除" icon="icon-entity-deleteline" bindAction="removeRow"/>
			</Dst:SMEDBillToolBar>  
			<Dst:SMEDColumnMoreHeaderGroup>
				<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
				<Dst:SMEDColumnBizPromptBox field="parent" hidden="true" queryFieldItem="number,name" title="父对象关联" entityPath="com.dst.slms.contractmange.entity.EconTermsAdjustInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnDateTimeBox field="adjustDate" align="center" title="日期"></Dst:SMEDColumnDateTimeBox>
				<Dst:SMEDColumnBizPromptBox field="payType" align="center" queryFieldItem="number,name" title="付款类型" DSTFilter="isEnable='Y'"  entityPath="com.dst.slms.base.entity.PayTypeInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnTextBox field="conditions" align="center" title="付款条件" width="100"></Dst:SMEDColumnTextBox>
				<Dst:SMEDColumnNumberBox field="rate" align="center" title="付款比例%" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="amount" align="center" readonly="true" title="已付金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="payAmount" align="center" title="付款金额" precision="2"></Dst:SMEDColumnNumberBox>
			</Dst:SMEDColumnMoreHeaderGroup>
		</Dst:SMEDDatagrid>
	</Dst:SMForm>	
</Dst:SMMain>
</div>
</body>
