<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/common/common.jsp"%>
<head>
<Dst:SMBase type="jquery,eui" pakgagePath="com.dst.slms.base.signinginfo.signingInfoEdit" uipk="signingInfoController" title="签约信息"/>
</head>
<body class="dst-mainbackground">
<div class="dst-container">

<Dst:SMMain title="签约信息">
	<Dst:SMEDBillToolBar >
	   <Dst:SMDGToolBar title="保存" icon="fa fa-save" bindAction="saveAction"/>
	   <Dst:SMDGToolBar title="提交并关闭" icon="fa fa-clipboard" bindAction="submitAction"/>
	   <Dst:SMDGToolBar title="关闭" icon="fa fa-rotate-left" bindAction="closeAction"/>
	</Dst:SMEDBillToolBar> 
	<Dst:SMForm formid="formobj" >
		<input id="id" name="id" type="hidden" value="${model.id }">
		<div class="easyui-panel" title="签约信息<span>信息</span>" style="width:100%;" data-options="bodyCls:'panle-background',collapsible:true,headerCls:'panel-block-teal panel-description'">
			<div style="padding-top: 10px"></div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">签约编号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="number" required="true" validType="['maxLength[100]']" width="100%" value="${model.number}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">签约名称</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="name" required="true" validType="['maxLength[100]']" width="100%" value="${model.name}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">营销项目</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="project" required="true" DSTFilter="isEnable='Y'" queryFieldItem="number,name" entityPath="com.dst.slms.base.entity.MarketProjectInfo" width="100%" value="${model.project}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">客户</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="customer" required="true" DSTFilter="isEnable='Y'" queryFieldItem="number,name" entityPath="com.dst.slms.base.entity.CustomerInfoInfo" width="100%" value="${model.customer}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">成交金额</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="amount" required="true" precision="2" width="100%" value="${model.amount}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">成交时间</label>
					<div class="dst-input-block">
						<Dst:SMDateTimeBox id="successDate" required="true" width="100%" value="${model.successDate}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label"></label>
					<div class="dst-input-block">
						<Dst:SMCheckBox id="isEnable"  label="是否启用"  value="${model.isEnable}"/>
					</div>
				</div>
			</div>
		</div>	
	</Dst:SMForm>	
</Dst:SMMain>
</div>
</body>
