package com.dst.slms.supplierreview.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.supplierreview.entity.ReviewTypeInfo;
import com.dst.slms.supplierreview.service.IReviewTypeService;

/**   
 * @Title: 评审类型 ServiceImpl
 * @Description: 评审类型
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IReviewTypeServiceImpl extends CrudServiceImpl<ReviewTypeInfo> implements IReviewTypeService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IReviewTypeServiceImpl.class);

	@Autowired
	private IReviewTypeService iReviewTypeService;
	
	public R changeEnable(ReviewTypeInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iReviewTypeService.executeHql("update ReviewTypeInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}