package com.dst.slms.supplierprofile.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.entity.CoreInfo;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.SpringContextUtils;
import com.dst.slms.common.utils.SysCaCheUtil;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.supplierprofile.entity.SupplierProfileInfo;
import com.dst.slms.supplierprofile.service.ISupplierProfileService;
import com.dst.slms.system.entity.SysAreaInfo;
import com.dst.slms.system.service.ISysAreaService;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hibernate.criterion.Restrictions;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dst.slms.common.RedisUtils;
import com.dst.slms.common.annotation.SysPermissionName;
import org.springframework.web.bind.annotation.PostMapping;
/**   
 * @Title: 供应商档案 Controller
 * @Description: 供应商档案
 * @author 
 * @date 2020-05-02 13:43:19
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/supplierProfileController")
@SysPermissionName(name="供应商档案",type=Constant.MENU)
public class SupplierProfileController extends AbstractSupplierProfileController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SupplierProfileController.class);
	
	@Autowired
	private ISupplierProfileService iSupplierProfileService;
	@Autowired
	private ISysAreaService iSysAreaService;
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("sue:supplierProfile:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(SupplierProfileInfo info, HttpServletRequest req) {
		return iSupplierProfileService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("sue:supplierProfile:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(SupplierProfileInfo info, HttpServletRequest req) {
		return iSupplierProfileService.unAudit(info.getId());
	}
	
	@Override
	public ModelAndView editPage(SupplierProfileInfo info, HttpServletRequest req) {
		if (UIRuleUtil.isNotNull(info.getId())) {
			SelectorItemCollection editSelector = this.getEditSelector();
			Object entity = null;
			if (editSelector != null && editSelector.size() > 0) {
				entity = this.getService().getEntity(info.getClass(), info.getId(), editSelector);
			} else {
				entity = this.getService().getEntity(info.getClass(), info.getId());
			}
			req.setAttribute(this.getModleName(), entity);
			SupplierProfileInfo inri = (SupplierProfileInfo) entity;
			SysAreaInfo  cityBase= iSysAreaService.getById(SysAreaInfo.class, inri.getCityBase().getId());
			req.setAttribute("cityname",UIRuleUtil.isNotNull(cityBase.getParent())?cityBase.getParent().getName():"");
		}
		return super.editPage(info, req);
	}
	
	@Override
	public ModelAndView viewPage(SupplierProfileInfo info, HttpServletRequest req) {
		if (UIRuleUtil.isNotNull(info.getId())) {
			SelectorItemCollection editSelector = this.getEditSelector();
			Object entity = null;
			if (editSelector != null && editSelector.size() > 0) {
				entity = this.getService().getEntity(info.getClass(), info.getId(), editSelector);
			} else {
				entity = this.getService().getEntity(info.getClass(), info.getId());
			}
			req.setAttribute(this.getModleName(), entity);
			SupplierProfileInfo inri = (SupplierProfileInfo) entity;
			SysAreaInfo  cityBase= iSysAreaService.getById(SysAreaInfo.class, inri.getCityBase().getId());
			req.setAttribute("cityname",UIRuleUtil.isNotNull(cityBase.getParent())?cityBase.getParent().getName():"");
		}
		return super.viewPage(info, req);
	}
	
	@Override
	public EntityQuery getQueryExecutor(HttpServletRequest arg0, CoreInfo arg1, DataGrid arg2) {
		String type1 = arg0.getParameter("type1");
		String type = arg0.getParameter("type");
		EntityQuery eq = super.getQueryExecutor(arg0, arg1, arg2);
		if(UIRuleUtil.isNotNull(type)&&!type.equals("-1")){
			eq.eq("supplierClassificatio.id",type);
		}
		if(UIRuleUtil.isNotNull(type1)){
			SysAreaInfo  cityBase= iSysAreaService.getById(SysAreaInfo.class, type1);
			eq.inSql("cityBase.id","select fid from xr_sys_area where FDISPLAYNAME like '" + cityBase.getDisplayName()+ "%' ");
		}
		eq.add();
		return eq;
	}
	
	/**
	 * 通过直辖市获取省份
	 */
	@ResponseBody
	@RequestMapping(value="getCity")
	public R getCity(HttpServletRequest arg0){
		String cityBaseid = arg0.getParameter("cityBaseid");
		SysAreaInfo  cityBase= iSysAreaService.getById(SysAreaInfo.class, cityBaseid);
		R r = R.ok();
		r.put("cityname",UIRuleUtil.isNotNull(cityBase.getParent())?cityBase.getParent().getName():"");
		r.put("isShowMsg", "0");
		return r;
	}
	
	
	/**
	 * 供应商档案信息
	 */
	@ResponseBody
	@RequestMapping(value="getSupplierProfile")
	public R getSupplierProfile(HttpServletRequest arg0){
		String supplierProid = arg0.getParameter("supplierProid");
		SupplierProfileInfo  supplierProfile= iSupplierProfileService.getById(SupplierProfileInfo.class, supplierProid);
		R r = R.ok();
		r.put("name",supplierProfile.getName());
		r.put("isShowMsg", "0");
		return r;
	}

}
