package com.dst.slms.proapproval.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.entity.CoreInfo;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.SysContext;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.proapproval.entity.MonMarkMangeE1Info;
import com.dst.slms.proapproval.entity.MonMarkMangeInfo;
import com.dst.slms.proapproval.entity.ProjectApproveInfo;
import com.dst.slms.proapproval.service.IMonMarkMangeService;
import com.dst.slms.proapproval.service.IProjectApproveService;
import com.dst.slms.system.entity.SysOrgInfo;
import com.dst.slms.system.entity.SysPersonInfo;
import com.dst.slms.system.service.ISysPersonService;
import com.dst.slms.util.PersonHelper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hibernate.criterion.Restrictions;

import com.dst.slms.base.entity.MarketProjectInfo;
import com.dst.slms.base.service.IMarketProjectService;
import com.dst.slms.common.annotation.SysPermissionName;
import org.springframework.web.bind.annotation.PostMapping;
/**   
 * @Title: 月度营销计划 Controller
 * @Description: 月度营销计划
 * @author 
 * @date 2020-05-02 11:38:49
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/monMarkMangeController")
@SysPermissionName(name="月度营销计划",type=Constant.MENU)
public class MonMarkMangeController extends AbstractMonMarkMangeController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(MonMarkMangeController.class);
	
	@Autowired
	private IMonMarkMangeService iMonMarkMangeService;
	@Autowired
	private IMarketProjectService iMarketProjectService;
	@Autowired
	private ISysPersonService iSysPersonService;
	@Autowired
	private IProjectApproveService iProjectApproveService;
	
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("Moe:MonMarkMange:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(MonMarkMangeInfo info, HttpServletRequest req) {
		info=iMonMarkMangeService.getEntity(MonMarkMangeInfo.class, info.getId());
		List<MonMarkMangeE1Info> monMarkMangeE1 = info.getMonMarkMangeE1();
		for(int i=0;i<monMarkMangeE1.size();i++){
			MonMarkMangeE1Info monE1info = monMarkMangeE1.get(i);
			ProjectApproveInfo proAppinfo = new ProjectApproveInfo();
			proAppinfo.setNumber(getService().getNumber(proAppinfo.getClass().getName()));
			proAppinfo.setState("SAVE");
			proAppinfo.setSourceBillId(monE1info.getId());
			proAppinfo.setItemDes(monE1info.getItemDes());
			proAppinfo.setBizdate(new Date());
			proAppinfo.setPlanType(monE1info.getPlanType());
			proAppinfo.setMarkaccount(monE1info.getMarketAccount());
			proAppinfo.setTheme(monE1info.getTheme());
			proAppinfo.setMonMarkMange(info);
			proAppinfo.setIsglcontract(monE1info.getIsglcontract());
			proAppinfo.setLxAmt(monE1info.getPlanAmt());
			proAppinfo.setProject(info.getProject());
			proAppinfo.setContractNature(monE1info.getContractNature());
			proAppinfo.setOrgunit(info.getOrgunit());
			proAppinfo.setSupplier(monE1info.getSupplier());
			proAppinfo.setContract(monE1info.getContact());
			proAppinfo.setStartNote(monE1info.getStartNote());
			proAppinfo.setMonAmt(monE1info.getMonAmt());
			proAppinfo.setPurType(monE1info.getPurType());
			proAppinfo.setRemake(monE1info.getRemark());
			proAppinfo.setIsLast(true);
			proAppinfo.setVersion(1);
			iProjectApproveService.save(proAppinfo);
		}
		String sql="update yc_cost_MonMarkMange set Fistolx='Y' where fid ='"+info.getId()+"'";
		iMonMarkMangeService.executeSql(sql);
		return iMonMarkMangeService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("Moe:MonMarkMange:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(MonMarkMangeInfo info, HttpServletRequest req) {
		info=iMonMarkMangeService.getEntity(MonMarkMangeInfo.class, info.getId());
		if(info.getIstolx()){
			throw new BizException("已生成立项单,不允许反审批");
		}
		return iMonMarkMangeService.unAudit(info.getId());
	}
	@Override
	public Object createNewModel(HttpServletRequest req) {
		// TODO 自动生成的方法存根
		String personId = SysContext.getPersonId();
		SysOrgInfo department = PersonHelper.getPersonForSysOrgUnit(personId);
		MonMarkMangeInfo info = new MonMarkMangeInfo();
		String id = req.getParameter("id");
		MarketProjectInfo proinfo = iMarketProjectService.getEntity(MarketProjectInfo.class, id,new String[]{"name","org.id","org.name"});
		info.setProject(proinfo);
		info.setOrgunit(proinfo.getOrg());
		SysPersonInfo personinfo = iSysPersonService.getEntity(SysPersonInfo.class, id,new String[]{"name"});
		info.setPerson(personinfo);
		info.setDepartment(department);
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public EntityQuery getQueryExecutor(HttpServletRequest request, CoreInfo info, DataGrid dataGrid) {
		// TODO 自动生成的方法存根
		EntityQuery queryExecutor = super.getQueryExecutor(request, info, dataGrid);
		//选中左边树节点ID
		String selectTreeId = request.getParameter("selectTreeId");
		 
		if(UIRuleUtil.isNotNull(selectTreeId)){
			String[] split = selectTreeId.split(",");
			queryExecutor.in("project.id", split);
		}else{
			queryExecutor.eq("project.id", "xxxx");
		}
		queryExecutor.add();
		return queryExecutor;
	}
	@Override
	public void verifyInput(CoreInfo info, HttpServletRequest req) {
		// TODO 自动生成的方法存根
		MonMarkMangeInfo moninfo=(MonMarkMangeInfo)info;
		if(moninfo.getMonMarkMangeE1().size()==0){
			throw new BizException("请填写分录数据");
		}
		BigDecimal amt=BigDecimal.ZERO;
		HashMap<String, BigDecimal> hashMap = new HashMap<>();
		for(int i=0;i<moninfo.getMonMarkMangeE1().size();i++){
			MonMarkMangeE1Info monMarkMangeE1Info = moninfo.getMonMarkMangeE1().get(i);
			BigDecimal planAmt = UIRuleUtil.getBigDecimal(monMarkMangeE1Info.getPlanAmt());
			amt=amt.add(planAmt);
			String theme = monMarkMangeE1Info.getTheme();
			if(hashMap.containsKey(theme)){//将主题一样的金额，汇总到一起
				BigDecimal bigDecimal = hashMap.get(theme);
				hashMap.put(theme, planAmt.add(bigDecimal));
			}else{
				hashMap.put(theme, planAmt);
			}
		}
		for(int i=0;i<moninfo.getMonMarkMangeE1().size();i++){
			MonMarkMangeE1Info monMarkMangeE1Info = moninfo.getMonMarkMangeE1().get(i);
			String theme = monMarkMangeE1Info.getTheme();
			BigDecimal bigDecimal = hashMap.get(theme);
			monMarkMangeE1Info.setThemeAmt(bigDecimal);//主题金额
		}
		moninfo.setTotalAMT(amt);
		super.verifyInput(moninfo, req);
	}
}
