package com.dst.slms.proapproval.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 立项单 Info 对象
 * @Description: 立项单
 * @author 
 * @date 2020-05-04 18:38:37
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractProjectApproveInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="单据编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@Column(name ="FitemDes")
	@FieldMeta(name="事项描述" )
	private java.lang.String itemDes;
	
	@Column(name ="Fbizdate")
	@FieldMeta(name="业务日期" )
	private java.util.Date bizdate;
	
	@Column(name ="FplanType")
	@FieldMeta(name="计划类型" ,enumGroupNumber="planType")
	private java.lang.String planType;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarkaccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="营销科目" )
	private com.dst.slms.base.entity.MarketAccountInfo markaccount;
	
	@Column(name ="Ftheme")
	@FieldMeta(name="主题" )
	private java.lang.String theme;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmonMarkMangeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="月度营销计划" )
	private com.dst.slms.proapproval.entity.MonMarkMangeInfo monMarkMange;
	
	@Column(name ="Fisoutplan")
	@FieldMeta(name="是否主题计划外" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isoutplan;
	
	@Column(name ="FismonPay")
	@FieldMeta(name="当月是否需要支付" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean ismonPay;
	
	@Column(name ="Fisglcontract")
	@FieldMeta(name="是否关联框架合同" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isglcontract;
	
	@Column(name ="FistoContract")
	@FieldMeta(name="是否生成合同" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean istoContract;
	
	@Column(name ="FlxAmt")
	@FieldMeta(name="立项金额" )
	private java.math.BigDecimal lxAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@Column(name ="F合同性质")
	@FieldMeta(name="合同性质" ,enumGroupNumber="contractNature")
	private java.lang.String contractNature;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgunitID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="所属组织" )
	private com.dst.slms.system.entity.SysOrgInfo orgunit;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同名称" )
	private com.dst.slms.contractmange.entity.SaleContractInfo contract;
	
	@Column(name ="FstartNote")
	@FieldMeta(name="开始节点" ,enumGroupNumber="startNote")
	private java.lang.String startNote;
	
	@Column(name ="FmonAmt")
	@FieldMeta(name="当月使用金额" )
	private java.math.BigDecimal monAmt;
	
	@Column(name ="FpurType")
	@FieldMeta(name="采购方式" ,enumGroupNumber="purType")
	private java.lang.String purType;
	
	@Column(name ="FisLast")
	@FieldMeta(name="是否最新版" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isLast;
	
	@Column(name ="Fversion")
	@FieldMeta(name="版本号" )
	private java.lang.Integer version;
	
	@Column(name ="FproAppID")
	@FieldMeta(name="修订源单据" )
	private java.lang.String proApp;
	
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  事项描述
	 */
	public java.lang.String getItemDes(){
		return this.itemDes;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  事项描述
	 */
	public void setItemDes(java.lang.String itemDes){
		this.itemDes = itemDes;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  业务日期
	 */
	public java.util.Date getBizdate(){
		return this.bizdate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  业务日期
	 */
	public void setBizdate(java.util.Date bizdate){
		this.bizdate = bizdate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  计划类型
	 */
	public java.lang.String getPlanType(){
		return this.planType;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  计划类型
	 */
	public void setPlanType(java.lang.String planType){
		this.planType = planType;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarkaccount(){
		return this.markaccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public void setMarkaccount(com.dst.slms.base.entity.MarketAccountInfo markaccount){
		this.markaccount = markaccount;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  主题
	 */
	public java.lang.String getTheme(){
		return this.theme;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  主题
	 */
	public void setTheme(java.lang.String theme){
		this.theme = theme;
	}
	/**
	 *方法: 取得com.dst.slms.proapproval.entity.MonMarkMangeInfo
	 *@return: com.dst.slms.proapproval.entity.MonMarkMangeInfo  月度营销计划
	 */
	public com.dst.slms.proapproval.entity.MonMarkMangeInfo getMonMarkMange(){
		return this.monMarkMange;
	}

	/**
	 *方法: 设置com.dst.slms.proapproval.entity.MonMarkMangeInfo
	 *@param: com.dst.slms.proapproval.entity.MonMarkMangeInfo  月度营销计划
	 */
	public void setMonMarkMange(com.dst.slms.proapproval.entity.MonMarkMangeInfo monMarkMange){
		this.monMarkMange = monMarkMange;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否主题计划外
	 */
	public boolean getIsoutplan(){
		return this.isoutplan;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否主题计划外
	 */
	public void setIsoutplan(boolean isoutplan){
		this.isoutplan = isoutplan;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  当月是否需要支付
	 */
	public boolean getIsmonPay(){
		return this.ismonPay;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  当月是否需要支付
	 */
	public void setIsmonPay(boolean ismonPay){
		this.ismonPay = ismonPay;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否关联框架合同
	 */
	public boolean getIsglcontract(){
		return this.isglcontract;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否关联框架合同
	 */
	public void setIsglcontract(boolean isglcontract){
		this.isglcontract = isglcontract;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否生成合同
	 */
	public boolean getIstoContract(){
		return this.istoContract;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否生成合同
	 */
	public void setIstoContract(boolean istoContract){
		this.istoContract = istoContract;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  立项金额
	 */
	public java.math.BigDecimal getLxAmt(){
		return this.lxAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  立项金额
	 */
	public void setLxAmt(java.math.BigDecimal lxAmt){
		this.lxAmt = lxAmt;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同性质
	 */
	public java.lang.String getContractNature(){
		return this.contractNature;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同性质
	 */
	public void setContractNature(java.lang.String contractNature){
		this.contractNature = contractNature;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  所属组织
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrgunit(){
		return this.orgunit;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  所属组织
	 */
	public void setOrgunit(com.dst.slms.system.entity.SysOrgInfo orgunit){
		this.orgunit = orgunit;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplier(){
		return this.supplier;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public void setSupplier(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier){
		this.supplier = supplier;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同名称
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getContract(){
		return this.contract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同名称
	 */
	public void setContract(com.dst.slms.contractmange.entity.SaleContractInfo contract){
		this.contract = contract;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  开始节点
	 */
	public java.lang.String getStartNote(){
		return this.startNote;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  开始节点
	 */
	public void setStartNote(java.lang.String startNote){
		this.startNote = startNote;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  当月使用金额
	 */
	public java.math.BigDecimal getMonAmt(){
		return this.monAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  当月使用金额
	 */
	public void setMonAmt(java.math.BigDecimal monAmt){
		this.monAmt = monAmt;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  采购方式
	 */
	public java.lang.String getPurType(){
		return this.purType;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  采购方式
	 */
	public void setPurType(java.lang.String purType){
		this.purType = purType;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否最新版
	 */
	public boolean getIsLast(){
		return this.isLast;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否最新版
	 */
	public void setIsLast(boolean isLast){
		this.isLast = isLast;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  版本号
	 */
	public java.lang.Integer getVersion(){
		return this.version;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  版本号
	 */
	public void setVersion(java.lang.Integer version){
		this.version = version;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修订源单据
	 */
	public java.lang.String getProApp(){
		return this.proApp;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修订源单据
	 */
	public void setProApp(java.lang.String proApp){
		this.proApp = proApp;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "IQB108MF";
	}
}
