package com.dst.slms.proapproval.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 月度营销计划 Info 对象
 * @Description: 月度营销计划
 * @author 
 * @date 2020-05-05 08:27:15
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractMonMarkMangeInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="单据编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="说明" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpersonID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="申请人" )
	private com.dst.slms.system.entity.SysPersonInfo person;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FdepartmentID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="申请人部门" )
	private com.dst.slms.system.entity.SysOrgInfo department;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@Column(name ="FtotalAMT")
	@FieldMeta(name="总计划费用" )
	private java.math.BigDecimal totalAMT;
	
	@Column(name ="Fyear")
	@FieldMeta(name="计划年份" ,enumGroupNumber="year")
	private java.lang.String year;
	
	@Column(name ="Fmonth")
	@FieldMeta(name="计划月份" ,enumGroupNumber="month")
	private java.lang.String month;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "Forgunit")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="所属组织" )
	private com.dst.slms.system.entity.SysOrgInfo orgunit;
	
	@Column(name ="Fistolx")
	@FieldMeta(name="是否生成立项" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean istolx;
	
	@Column(name ="Fxsmb")
	@FieldMeta(name="销售目标" )
	private java.math.BigDecimal xsmb;
	
	@Column(name ="Frate")
	@FieldMeta(name="费率" )
	private java.math.BigDecimal rate;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<MonMarkMangeE1Info> monMarkMangeE1 = new ArrayList<MonMarkMangeE1Info>(); 

	public List<MonMarkMangeE1Info> getMonMarkMangeE1() {
		return monMarkMangeE1;
	}

	public void setMonMarkMangeE1(List<MonMarkMangeE1Info> MonMarkMangeE1) {
		this.monMarkMangeE1 = MonMarkMangeE1;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysPersonInfo
	 *@return: com.dst.slms.system.entity.SysPersonInfo  申请人
	 */
	public com.dst.slms.system.entity.SysPersonInfo getPerson(){
		return this.person;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysPersonInfo
	 *@param: com.dst.slms.system.entity.SysPersonInfo  申请人
	 */
	public void setPerson(com.dst.slms.system.entity.SysPersonInfo person){
		this.person = person;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  申请人部门
	 */
	public com.dst.slms.system.entity.SysOrgInfo getDepartment(){
		return this.department;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  申请人部门
	 */
	public void setDepartment(com.dst.slms.system.entity.SysOrgInfo department){
		this.department = department;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  总计划费用
	 */
	public java.math.BigDecimal getTotalAMT(){
		return this.totalAMT;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  总计划费用
	 */
	public void setTotalAMT(java.math.BigDecimal totalAMT){
		this.totalAMT = totalAMT;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  计划年份
	 */
	public java.lang.String getYear(){
		return this.year;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  计划年份
	 */
	public void setYear(java.lang.String year){
		this.year = year;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  计划月份
	 */
	public java.lang.String getMonth(){
		return this.month;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  计划月份
	 */
	public void setMonth(java.lang.String month){
		this.month = month;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  所属组织
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrgunit(){
		return this.orgunit;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  所属组织
	 */
	public void setOrgunit(com.dst.slms.system.entity.SysOrgInfo orgunit){
		this.orgunit = orgunit;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否生成立项
	 */
	public boolean getIstolx(){
		return this.istolx;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否生成立项
	 */
	public void setIstolx(boolean istolx){
		this.istolx = istolx;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  销售目标
	 */
	public java.math.BigDecimal getXsmb(){
		return this.xsmb;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  销售目标
	 */
	public void setXsmb(java.math.BigDecimal xsmb){
		this.xsmb = xsmb;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  费率
	 */
	public java.math.BigDecimal getRate(){
		return this.rate;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  费率
	 */
	public void setRate(java.math.BigDecimal rate){
		this.rate = rate;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "EIBAOCPW";
	}
}
