package com.dst.slms.contractmange.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.entity.CoreInfo;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.contractmange.entity.SaleContractInfo;
import com.dst.slms.contractmange.service.ISaleContractService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hibernate.criterion.Restrictions;

import com.dst.slms.common.annotation.SysPermissionName;
import org.springframework.web.bind.annotation.PostMapping;
/**   
 * @Title: 营销合同 Controller
 * @Description: 营销合同
 * @author 
 * @date 2020-05-02 15:30:35
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/saleContractController")
@SysPermissionName(name="营销合同",type=Constant.MENU)
public class SaleContractController extends AbstractSaleContractController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SaleContractController.class);
	
	@Autowired
	private ISaleContractService iSaleContractService;
	
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("sat:saleContract:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(SaleContractInfo info, HttpServletRequest req) {
		return iSaleContractService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("sat:saleContract:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(SaleContractInfo info, HttpServletRequest req) {
		return iSaleContractService.unAudit(info.getId());
	}
	@Override
	public EntityQuery getQueryExecutor(HttpServletRequest request, CoreInfo info, DataGrid dataGrid) {
		EntityQuery eq = super.getQueryExecutor(request, info, dataGrid);
		//选中左边树节点ID
		String selectTreeId = request.getParameter("selectTreeId");
//		String typeTreeId = request.getParameter("typeTreeId");
		
		if((selectTreeId==null||"".equals(selectTreeId))){//||(typeTreeId==null||"".equals(typeTreeId))
			eq.add(Restrictions.eq("project.id","xxxx"));//一个树节点都没时默认不显示数据
			eq.add();
		}else{
			String[] split = selectTreeId.split(",");
//			eq.add(Restrictions.and(Restrictions.in("project.id", split), Restrictions.eq("contractType.id",typeTreeId)));
			eq.in("project.id", split);
			eq.add();
		}
		return eq;
	}
}
