package com.dst.slms.contractmange.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 付款申请单 Info 对象
 * @Description: 付款申请单
 * @author 
 * @date 2020-05-05 08:36:02
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractPaymentReqInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="付款申请单编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgunitID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="组织" )
	private com.dst.slms.system.entity.SysOrgInfo orgunit;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同编码" )
	private com.dst.slms.contractmange.entity.SaleContractInfo contract;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FjzcompanyID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="记账公司" )
	private com.dst.slms.system.entity.SysOrgInfo jzcompany;
	
	@Column(name ="FbizDate")
	@FieldMeta(name="业务日期" )
	private java.util.Date bizDate;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpayTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="付款类型" )
	private com.dst.slms.base.entity.PayTypeInfo payType;
	
	@Column(name ="FtaxReqAmt")
	@FieldMeta(name="含税申请金额" )
	private java.math.BigDecimal taxReqAmt;
	
	@Column(name ="FnoTaxReqAmt")
	@FieldMeta(name="不含税申请金额" )
	private java.math.BigDecimal noTaxReqAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FtaxRate")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="税率(%)" )
	private com.dst.slms.base.entity.TaxRateInfo taxRate;
	
	@Column(name ="FtaxAmt")
	@FieldMeta(name="税额" )
	private java.math.BigDecimal taxAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="收款单位" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier;
	
	@Column(name ="FljfpAmt")
	@FieldMeta(name="累计已到发票金额" )
	private java.math.BigDecimal ljfpAmt;
	
	@Column(name ="FmonAmt")
	@FieldMeta(name="项目累计当月已付金额" )
	private java.math.BigDecimal monAmt;
	
	@Column(name ="FcontractAmt")
	@FieldMeta(name="合同金额" )
	private java.math.BigDecimal contractAmt;
	
	@Column(name ="FljpayAmt")
	@FieldMeta(name="累计已付金额" )
	private java.math.BigDecimal ljpayAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FreceiptID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="验收单" )
	private com.dst.slms.contractmange.entity.ReceiptInfo receipt;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<PaymentReqE1Info> paymentReqE1 = new ArrayList<PaymentReqE1Info>(); 

	public List<PaymentReqE1Info> getPaymentReqE1() {
		return paymentReqE1;
	}

	public void setPaymentReqE1(List<PaymentReqE1Info> paymentReqE1) {
		this.paymentReqE1 = paymentReqE1;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  付款申请单编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  付款申请单编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  组织
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrgunit(){
		return this.orgunit;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  组织
	 */
	public void setOrgunit(com.dst.slms.system.entity.SysOrgInfo orgunit){
		this.orgunit = orgunit;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同编码
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getContract(){
		return this.contract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同编码
	 */
	public void setContract(com.dst.slms.contractmange.entity.SaleContractInfo contract){
		this.contract = contract;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  记账公司
	 */
	public com.dst.slms.system.entity.SysOrgInfo getJzcompany(){
		return this.jzcompany;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  记账公司
	 */
	public void setJzcompany(com.dst.slms.system.entity.SysOrgInfo jzcompany){
		this.jzcompany = jzcompany;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  业务日期
	 */
	public java.util.Date getBizDate(){
		return this.bizDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  业务日期
	 */
	public void setBizDate(java.util.Date bizDate){
		this.bizDate = bizDate;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.PayTypeInfo
	 *@return: com.dst.slms.base.entity.PayTypeInfo  付款类型
	 */
	public com.dst.slms.base.entity.PayTypeInfo getPayType(){
		return this.payType;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.PayTypeInfo
	 *@param: com.dst.slms.base.entity.PayTypeInfo  付款类型
	 */
	public void setPayType(com.dst.slms.base.entity.PayTypeInfo payType){
		this.payType = payType;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  含税申请金额
	 */
	public java.math.BigDecimal getTaxReqAmt(){
		return this.taxReqAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  含税申请金额
	 */
	public void setTaxReqAmt(java.math.BigDecimal taxReqAmt){
		this.taxReqAmt = taxReqAmt;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  不含税申请金额
	 */
	public java.math.BigDecimal getNoTaxReqAmt(){
		return this.noTaxReqAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  不含税申请金额
	 */
	public void setNoTaxReqAmt(java.math.BigDecimal noTaxReqAmt){
		this.noTaxReqAmt = noTaxReqAmt;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.TaxRateInfo
	 *@return: com.dst.slms.base.entity.TaxRateInfo  税率(%)
	 */
	public com.dst.slms.base.entity.TaxRateInfo getTaxRate(){
		return this.taxRate;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.TaxRateInfo
	 *@param: com.dst.slms.base.entity.TaxRateInfo  税率(%)
	 */
	public void setTaxRate(com.dst.slms.base.entity.TaxRateInfo taxRate){
		this.taxRate = taxRate;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  税额
	 */
	public java.math.BigDecimal getTaxAmt(){
		return this.taxAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  税额
	 */
	public void setTaxAmt(java.math.BigDecimal taxAmt){
		this.taxAmt = taxAmt;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  收款单位
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplier(){
		return this.supplier;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  收款单位
	 */
	public void setSupplier(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier){
		this.supplier = supplier;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  累计已到发票金额
	 */
	public java.math.BigDecimal getLjfpAmt(){
		return this.ljfpAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  累计已到发票金额
	 */
	public void setLjfpAmt(java.math.BigDecimal ljfpAmt){
		this.ljfpAmt = ljfpAmt;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  项目累计当月已付金额
	 */
	public java.math.BigDecimal getMonAmt(){
		return this.monAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  项目累计当月已付金额
	 */
	public void setMonAmt(java.math.BigDecimal monAmt){
		this.monAmt = monAmt;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  合同金额
	 */
	public java.math.BigDecimal getContractAmt(){
		return this.contractAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  合同金额
	 */
	public void setContractAmt(java.math.BigDecimal contractAmt){
		this.contractAmt = contractAmt;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  累计已付金额
	 */
	public java.math.BigDecimal getLjpayAmt(){
		return this.ljpayAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  累计已付金额
	 */
	public void setLjpayAmt(java.math.BigDecimal ljpayAmt){
		this.ljpayAmt = ljpayAmt;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.ReceiptInfo
	 *@return: com.dst.slms.contractmange.entity.ReceiptInfo  验收单
	 */
	public com.dst.slms.contractmange.entity.ReceiptInfo getReceipt(){
		return this.receipt;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.ReceiptInfo
	 *@param: com.dst.slms.contractmange.entity.ReceiptInfo  验收单
	 */
	public void setReceipt(com.dst.slms.contractmange.entity.ReceiptInfo receipt){
		this.receipt = receipt;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "OGS6BOFB";
	}
}
