package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.BaseTreeController;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.MarketAccountInfo;
import com.dst.slms.base.service.IMarketAccountService;

/**   
 * 营销科目 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 营销科目
 * @author 
 * @date 2020-05-02 13:12:42
 * @version V1.0   
 *
 */
public abstract class AbstractMarketAccountController extends BaseTreeController {

	@Autowired
	private IMarketAccountService iMarketAccountService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/marketaccount/marketAccountList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/marketaccount/marketAccountEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iMarketAccountService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		MarketAccountInfo info = new MarketAccountInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		sic.add("controlType");
		sic.add("isexcess");
		sic.add("excessRate");
		sic.add("isPut");
		sic.add("media.id");
		sic.add("media.number");
		sic.add("media.name");
		sic.add("isMonth");
		sic.add("isQuarter");
		sic.add("isYear");
		sic.add("parent.id");
		sic.add("parent.name");
		return sic;
	}
	
	@RequiresPermissions("mat:marketAccount:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(MarketAccountInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("mat:marketAccount:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("mat:marketAccount:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("mat:marketAccount:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(MarketAccountInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("mat:marketAccount:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(MarketAccountInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("mat:marketAccount:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(MarketAccountInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("mat:marketAccount:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(MarketAccountInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("mat:marketAccount:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(MarketAccountInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("mat:marketAccount:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(MarketAccountInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
