package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.PayTypeInfo;
import com.dst.slms.base.service.IPayTypeService;

/**   
 * @Title: 付款类型 ServiceImpl
 * @Description: 付款类型
 * @author 
 * @date 2020-05-02 15:33:23
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IPayTypeServiceImpl extends CrudServiceImpl<PayTypeInfo> implements IPayTypeService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IPayTypeServiceImpl.class);

	@Autowired
	private IPayTypeService iPayTypeService;
	
	public R changeEnable(PayTypeInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iPayTypeService.executeHql("update PayTypeInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}