package com.dst.slms.workBench.controller;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.dst.slms.base.entity.MarketAccountInfo;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.SpringContextUtils;
import com.dst.slms.common.utils.UIRuleUtil;

/**
 * @Title: 报表
 * @Description: 
 * @author
 * @date 2019-07-01 14:22:48
 * @version V1.0
 *
 */
@Controller
@RequestMapping("/report")
public class ReportController extends CoreBaseController {
    /**
     * 项目渠道情况表
     */
    @ResponseBody
    @RequestMapping(value = "/mediaReport")
    public ModelAndView mediaReport(HttpServletRequest req) {
        return new ModelAndView( "com/dst/slms/workBench/mediaReport" );
    }
    /**
     * 全盘-年度-月度计划实际对比
     */
    @ResponseBody
    @RequestMapping(value = "/cyclePaymentPlan")
    public ModelAndView cyclePaymentPlan(HttpServletRequest req) {
    	return new ModelAndView( "com/dst/slms/workBench/cyclePaymentPlan" );
    }


    @ResponseBody
    @RequestMapping(value = "mediaReportData")
    public void mediaReportData(HttpServletRequest request) {
    	String projectId = request.getParameter("projectId");
    	String fname = request.getParameter("fname");
    	StringBuffer sb = new StringBuffer();
    	sb.append(" select uuid() id,md.fname ctname,ac.fname,sum(a.FysAmt)/10000 amount ,sum(a.Flfcount) lfcount,case when sum(a.Flfcount)<>0 then sum(a.FysAmt)/sum(a.Flfcount) else 0 end lrfx,\r\n" + 
    			" case when sum(ct.Flfcount)<>0 then sum(a.Flfcount)/sum(ct.Flfcount)*100 else 0 end lrzb,\r\n" + 
    			" sum(a.Fcjcount) cjcount,case when sum(cts.Fcjcount)<>0 then sum(a.Fcjcount)/sum(cts.Fcjcount)*100 else 0 end cjzb,\r\n" + 
    			" case when sum(ctsf.FysAmt)<>0 then sum(a.FysAmt)/sum(ctsf.FysAmt)*100 else 0 end cjfyzb,\r\n" + 
    			" sum(a.FcjAmt)/10000  cjAmt,case when sum(cts.Fcjcount)<>0 then sum(a.FcjAmt)/sum(cts.Fcjcount) else 0 end cjfx\r\n" + 
    			" from yc_cost_receiptE3 a\r\n" + 
    			" left join yc_cost_receipt b on b.fid =a.fparentid\r\n" + 
    			" left join yc_cost_marketAccount ac on ac.fid = a.FmarkAccountID\r\n" + 
    			" left join yc_cost_mediaInfo md on md.fid = ac.FmediaID\r\n" + 
    			" left join (\r\n" + 
    			" select sum(b.Flfcount) Flfcount,a.FprojectID from yc_cost_receipt a\r\n" + 
    			" left join yc_cost_receiptE3 b on b.fparentid =a.fid\r\n" + 
    			" where a.FprojectID='"+projectId+"' and a.fstate='AUDIT'\r\n" + 
    			" ) ct on ct.FprojectID=b.FprojectID\r\n" + 
    			" left join (\r\n" + 
    			" select sum(b.Fcjcount) Fcjcount,a.FprojectID from yc_cost_receipt a\r\n" + 
    			" left join yc_cost_receiptE3 b on b.fparentid =a.fid\r\n" + 
    			" where a.FprojectID='"+projectId+"' and a.fstate='AUDIT'\r\n" + 
    			" ) cts on cts.FprojectID=b.FprojectID\r\n" + 
    			" left join (\r\n" + 
    			" select sum(b.FysAmt) FysAmt,a.FprojectID from yc_cost_receipt a\r\n" + 
    			" left join yc_cost_receiptE3 b on b.fparentid =a.fid\r\n" + 
    			" where a.FprojectID='"+projectId+"' and a.fstate='AUDIT'\r\n" + 
    			" ) ctsf on ctsf.FprojectID=b.FprojectID\r\n" + 
    			"");
    	sb.append(" where 1=1  ");
    	if(UIRuleUtil.isNotNull(fname)) {
    		sb.append(" and ac.fname like '%"+fname+"%'");
    	}
    	sb.append(" and b.fstate='AUDIT' and b.FprojectID='"+projectId+"' group by md.fname,ac.fname order by md.fname,ac.fname\r\n");
    	ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
		List result = iCrudService.executeSqlQuery(sb.toString());
    	Map mp = new HashMap<>();
		mp.put("rows", result);
		mp.put("total", result.size());
		writeSuccessJson(mp);
    }
    
    @ResponseBody
    @RequestMapping(value = "cyclePaymentPlanAccountData")
	public void list(HttpServletRequest request) {
    	String projectId = request.getParameter("projectId");
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("number", "asc");
		EntityQuery eq = new EntityQuery(MarketAccountInfo.class);
		eq.eq("isEnable", true);
		eq.setOrder(map);
		eq.add();
		ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
		List<MarketAccountInfo> list  = iCrudService.getEntityList(eq);
		
		MarketAccountInfo rootInfo = new MarketAccountInfo();
		rootInfo.setName("营销科目");
		rootInfo.setNumber("N000");
		rootInfo.setId("ROOT");
		list.add(0,rootInfo);
		
		Calendar cal = Calendar.getInstance();
    	int year = cal.get(Calendar.YEAR);
    	int month = cal.get(Calendar.MONTH )+1;
		Map<String, Map<String, Object>> allProjectData = getAllProjectData(projectId);
		Map<String, Map<String, Object>> yearProjectData = getYearProjectData(projectId,year);
		Map<String, Map<String, Object>> monthProjectData = getMonthProjectData(projectId,year,month);
		List<Map<String,Object>> resultList = new ArrayList<>();
		list.forEach(per->{
			
			Map<String,Object> value = new HashMap<>();
			if(per.getParent()!=null) {
				value.put("_parentId", per.getParent().getId());
			}else if(!"N000".equals(per.getNumber())){
				value.put("_parentId", "ROOT");
			}
			value.put("id", per.getId());
			value.put("state", "open");
			value.put("icon", "");
			
			Map<String, Object> map2 = allProjectData.get(per.getId());
			Map<String, Object> map3 = yearProjectData.get(per.getId());
			Map<String, Object> map4 = monthProjectData.get(per.getId());
			value.put("planAmount", UIRuleUtil.getBigDecimal(map2!=null?map2.get("planamount"):0));
			value.put("yfsAmount", UIRuleUtil.getBigDecimal(map2!=null?map2.get("yfsAmount"):0));
			value.put("ysfsAmount", UIRuleUtil.getBigDecimal(map2!=null?map2.get("ysfsAmount"):0));
			value.put("jhAmount", UIRuleUtil.getBigDecimal(map2!=null?map2.get("jhAmount"):0));
			value.put("amount", UIRuleUtil.getBigDecimal(map2!=null?map2.get("amount"):0));
			
			value.put("yfsAmount1", UIRuleUtil.getBigDecimal(map3!=null?map3.get("yfsAmount"):0));
			value.put("ysfsAmount1", UIRuleUtil.getBigDecimal(map3!=null?map3.get("ysfsAmount"):0));
			value.put("jhAmount1", UIRuleUtil.getBigDecimal(map3!=null?map3.get("jhAmount"):0));
			value.put("amount1", UIRuleUtil.getBigDecimal(map3!=null?map3.get("amount"):0));
			
			value.put("yfsAmount2", UIRuleUtil.getBigDecimal(map4!=null?map4.get("yfsAmount"):0));
			value.put("ysfsAmount2", UIRuleUtil.getBigDecimal(map4!=null?map4.get("ysfsAmount"):0));
			value.put("jhAmount2", UIRuleUtil.getBigDecimal(map4!=null?map4.get("jhAmount"):0));
			value.put("amount2", UIRuleUtil.getBigDecimal(map4!=null?map4.get("amount"):0));
			
			
			value.put("isLeaf", per.getIsLeaf());
			value.put("name", per.getName());
			value.put("number",per.getNumber());
			resultList.add(value);
		});
		Map mp = new HashMap<>();
		mp.put("rows", resultList);
		mp.put("total", list.size());
		writeSuccessJson(mp);
	}
    
    /**
     * 获取项目年度规划
     * @param projectId
     * @return
     */
    private Map<String,Map<String,Object>> getYearProjectData(String projectId,int year){
    	StringBuffer sb = new StringBuffer();
    	sb.append(" select a.FprojectID,a.accId,sum(a.planamount) planamount,sum(a.yfsAmount)yfsAmount,sum(a.ysfsAmount)ysfsAmount,sum(a.jhAmount)jhAmount,sum(a.amount)amount from (\r\n" + 
    			" select b.FprojectID,a.fmarketAccountid accId,a.fplanamount planamount,0 yfsAmount,0 ysfsAmount,0 jhAmount,0 amount from yc_cost_CyclePaymentPlanE1 a\r\n" + 
    			" left join yc_cost_CyclePaymentPlan b on b.fid = a.fparentid\r\n" + 
    			" where b.Fisnew='Y'\r\n" + 
    			" union all\r\n" + 
    			" select a.FprojectID,a.FmarkAccountID accId,0 planamount,case when a.FisSettlement='Y' then a.FsettlementAmt else a.FtaxConAmt end yfsAmount,0 ysfsAmount,0 jhAmount,0 amount\r\n" + 
    			" from yc_cost_saleContract a\r\n" + 
    			" where a.fstate='AUDIT' and year(a.FsignDate)='"+year+"'  \r\n" + 
    			" union all\r\n" + 
    			" select b.FprojectID,a.FaccountNumberID accId,0 planamount,0 yfsAmount,a.amount ysfsAmount,0 jhAmount,0 amount from (\r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','01-02') dt,a.Fone amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','02-01') dt,a.Ftwo amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','03-01') dt,a.Fthree amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','04-01') dt,a.Ffour amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','05-01') dt,a.Ffive amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','06-01') dt,a.Fsix amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','07-01') dt,a.Fseven amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','08-01') dt,a.Feight amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','09-01') dt,a.Fnine amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','10-01') dt,a.Ften amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','11-01') dt,a.Feleven amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','12-01') dt,a.Ftwelve amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT' ) a left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid and year(STR_TO_DATE(a.dt,'%Y-%m-%d'))='"+year+"' \r\n" + 
    			" union all\r\n" + 
    			" select b.FmarketProjectID FprojectID,a.FmarketAccounID accId,0 planamount,0 yfsAmount,0 ysfsAmount,a.amount jhAmount,0 amount from (\r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','01-01') dt,a.Fjan amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','02-01') dt,a.Ffeb amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','03-01') dt,a.Fmar amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','04-01') dt,a.Fapr amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','05-01') dt,a.Fmay amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','06-01') dt,a.Fjun amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','07-01') dt,a.Fjul amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','08-01') dt,a.Faug amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','09-01') dt,a.Fsep amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','10-01') dt,a.Foct amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','11-01') dt,a.Fnov amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','12-01') dt,a.Fdec amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" ) a left join yc_cost_annualPaymentPlan b on b.fid = a.fparentid and year(STR_TO_DATE(a.dt,'%Y-%m-%d'))='"+year+"' \r\n" + 
    			" union all \r\n" + 
    			" select a.FprojectID,c.FmarkAccountID accId,0 planamount,0 yfsAmount,0 ysfsAmount,0 jhAmounta,a.FtaxReqAmt amount from yc_cost_paymentReq a \r\n" + 
    			" left join yc_cost_saleContract c on c.fid =a.FcontractID\r\n" + 
    			" where a.fstate='AUDIT'  and year(a.FbizDate)='"+year+"' )a where a.FprojectID='"+projectId+"'").append(" group by a.FprojectID,a.accId");
    	ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
    	List<Map<String,Object>> list = iCrudService.executeSqlQuery(sb.toString());
    	
    	Map<String,Map<String,Object>> resultMap = new HashMap<>();
    	list.forEach(m ->{
    		String accId = UIRuleUtil.getString(m.get("accId"));
    		Map<String,Object> value = new HashMap<>();
    		value.put("planamount", m.get("planamount"));
    		value.put("yfsAmount", m.get("yfsAmount"));
    		value.put("ysfsAmount", m.get("ysfsAmount"));
    		value.put("jhAmount", m.get("jhAmount"));
    		value.put("amount", m.get("amount"));
    		resultMap.put(accId, value);
    	});
    	return resultMap;
    }
    /**
     * 获取项目月度规划
     * @param projectId
     * @return
     */
    private Map<String,Map<String,Object>> getMonthProjectData(String projectId,int year,int month){
    	StringBuffer sb = new StringBuffer();
    	sb.append(" select a.FprojectID,a.accId,sum(a.planamount) planamount,sum(a.yfsAmount)yfsAmount,sum(a.ysfsAmount)ysfsAmount,sum(a.jhAmount)jhAmount,sum(a.amount)amount from (\r\n" + 
    			" select b.FprojectID,a.fmarketAccountid accId,a.fplanamount planamount,0 yfsAmount,0 ysfsAmount,0 jhAmount,0 amount from yc_cost_CyclePaymentPlanE1 a\r\n" + 
    			" left join yc_cost_CyclePaymentPlan b on b.fid = a.fparentid\r\n" + 
    			" where b.Fisnew='Y'\r\n" + 
    			" union all\r\n" + 
    			" select a.FprojectID,a.FmarkAccountID accId,0 planamount,case when a.FisSettlement='Y' then a.FsettlementAmt else a.FtaxConAmt end yfsAmount,0 ysfsAmount,0 jhAmount,0 amount\r\n" + 
    			" from yc_cost_saleContract a\r\n" + 
    			" where a.fstate='AUDIT' and year(a.FsignDate)='"+year+"' and year(a.FsignDate)='"+month+"' \r\n" + 
    			" union all\r\n" + 
    			" select b.FprojectID,a.FaccountNumberID accId,0 planamount,0 yfsAmount,a.amount ysfsAmount,0 jhAmount,0 amount from (\r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','01-02') dt,a.Fone amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','02-01') dt,a.Ftwo amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','03-01') dt,a.Fthree amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','04-01') dt,a.Ffour amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','05-01') dt,a.Ffive amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','06-01') dt,a.Fsix amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','07-01') dt,a.Fseven amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','08-01') dt,a.Feight amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','09-01') dt,a.Fnine amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','10-01') dt,a.Ften amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','11-01') dt,a.Feleven amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','12-01') dt,a.Ftwelve amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT' ) a left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid and year(STR_TO_DATE(a.dt,'%Y-%m-%d'))='"+year+"'  and month(STR_TO_DATE(a.dt,'%Y-%m-%d'))='"+month+"'  \r\n" + 
    			" union all\r\n" + 
    			" select b.FmarketProjectID FprojectID,a.FmarketAccounID accId,0 planamount,0 yfsAmount,0 ysfsAmount,a.amount jhAmount,0 amount from (\r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','01-01') dt,a.Fjan amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','02-01') dt,a.Ffeb amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','03-01') dt,a.Fmar amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','04-01') dt,a.Fapr amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','05-01') dt,a.Fmay amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','06-01') dt,a.Fjun amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','07-01') dt,a.Fjul amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','08-01') dt,a.Faug amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','09-01') dt,a.Fsep amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','10-01') dt,a.Foct amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','11-01') dt,a.Fnov amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','12-01') dt,a.Fdec amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" ) a left join yc_cost_annualPaymentPlan b on b.fid = a.fparentid and year(STR_TO_DATE(a.dt,'%Y-%m-%d'))='"+year+"' and month(STR_TO_DATE(a.dt,'%Y-%m-%d'))='"+month+"' \r\n" + 
    			" union all \r\n" + 
    			" select a.FprojectID,c.FmarkAccountID accId,0 planamount,0 yfsAmount,0 ysfsAmount,0 jhAmounta,a.FtaxReqAmt amount from yc_cost_paymentReq a \r\n" + 
    			" left join yc_cost_saleContract c on c.fid =a.FcontractID\r\n" + 
    			" where a.fstate='AUDIT'  and year(a.FbizDate)='"+year+"'  and month(a.FbizDate)='"+month+"' )a where a.FprojectID='"+projectId+"'").append(" group by a.FprojectID,a.accId");
    	ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
    	List<Map<String,Object>> list = iCrudService.executeSqlQuery(sb.toString());
    	
    	Map<String,Map<String,Object>> resultMap = new HashMap<>();
    	list.forEach(m ->{
    		String accId = UIRuleUtil.getString(m.get("accId"));
    		Map<String,Object> value = new HashMap<>();
    		value.put("planamount", m.get("planamount"));
    		value.put("yfsAmount", m.get("yfsAmount"));
    		value.put("ysfsAmount", m.get("ysfsAmount"));
    		value.put("jhAmount", m.get("jhAmount"));
    		value.put("amount", m.get("amount"));
    		resultMap.put(accId, value);
    	});
    	return resultMap;
    }
    /**
     * 获取项目全盘规划
     * @param projectId
     * @return
     */
    private Map<String,Map<String,Object>> getAllProjectData(String projectId){
    	StringBuffer sb = new StringBuffer();
    	sb.append(" select a.FprojectID,a.accId,sum(a.planamount) planamount,sum(a.yfsAmount)yfsAmount,sum(a.ysfsAmount)ysfsAmount,sum(a.jhAmount)jhAmount,sum(a.amount)amount from (\r\n" + 
    			" select b.FprojectID,a.fmarketAccountid accId,a.fplanamount planamount,0 yfsAmount,0 ysfsAmount,0 jhAmount,0 amount from yc_cost_CyclePaymentPlanE1 a\r\n" + 
    			" left join yc_cost_CyclePaymentPlan b on b.fid = a.fparentid\r\n" + 
    			" where b.Fisnew='Y'\r\n" + 
    			" union all\r\n" + 
    			" select a.FprojectID,a.FmarkAccountID accId,0 planamount,case when a.FisSettlement='Y' then a.FsettlementAmt else a.FtaxConAmt end yfsAmount,0 ysfsAmount,0 jhAmount,0 amount\r\n" + 
    			" from yc_cost_saleContract a\r\n" + 
    			" where a.fstate='AUDIT'\r\n" + 
    			" union all\r\n" + 
    			" select b.FprojectID,a.FaccountNumberID accId,0 planamount,0 yfsAmount,a.amount ysfsAmount,0 jhAmount,0 amount from (\r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','01-02') dt,a.Fone amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','02-01') dt,a.Ftwo amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','03-01') dt,a.Fthree amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','04-01') dt,a.Ffour amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','05-01') dt,a.Ffive amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','06-01') dt,a.Fsix amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','07-01') dt,a.Fseven amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','08-01') dt,a.Feight amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','09-01') dt,a.Fnine amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','10-01') dt,a.Ften amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','11-01') dt,a.Feleven amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select fparentid,FaccountNumberID,concat(b.Fyear,'-','12-01') dt,a.Ftwelve amount from yc_cost_ProjectYearBudgetE1 a\r\n" + 
    			" left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" where b.fstate='AUDIT' ) a left join yc_cost_ProjectYearBudget b on b.fid = a.fparentid\r\n" + 
    			" union all\r\n" + 
    			" select b.FmarketProjectID FprojectID,a.FmarketAccounID accId,0 planamount,0 yfsAmount,0 ysfsAmount,a.amount jhAmount,0 amount from (\r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','01-01') dt,a.Fjan amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','02-01') dt,a.Ffeb amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','03-01') dt,a.Fmar amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','04-01') dt,a.Fapr amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','05-01') dt,a.Fmay amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','06-01') dt,a.Fjun amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','07-01') dt,a.Fjul amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','08-01') dt,a.Faug amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','09-01') dt,a.Fsep amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','10-01') dt,a.Foct amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','11-01') dt,a.Fnov amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" union all \r\n" + 
    			" select a.fparentid,a.FmarketAccounID,concat(b.Fyear,'-','12-01') dt,a.Fdec amount from yc_cost_annualPlanDetails a\r\n" + 
    			" left join yc_cost_annualPaymentPlan b on b.fid =a.fparentid where b.fstate='AUDIT'\r\n" + 
    			" ) a left join yc_cost_annualPaymentPlan b on b.fid = a.fparentid\r\n" + 
    			" union all \r\n" + 
    			" select a.FprojectID,c.FmarkAccountID accId,0 planamount,0 yfsAmount,0 ysfsAmount,0 jhAmounta,a.FtaxReqAmt amount from yc_cost_paymentReq a \r\n" + 
    			" left join yc_cost_saleContract c on c.fid =a.FcontractID\r\n" + 
    			" where a.fstate='AUDIT' )a where a.FprojectID='"+projectId+"'").append(" group by a.FprojectID,a.accId");
    	ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
    	List<Map<String,Object>> list = iCrudService.executeSqlQuery(sb.toString());
    	
    	Map<String,Map<String,Object>> resultMap = new HashMap<>();
    	list.forEach(m ->{
    		String accId = UIRuleUtil.getString(m.get("accId"));
    		Map<String,Object> value = new HashMap<>();
    		value.put("planamount", m.get("planamount"));
    		value.put("yfsAmount", m.get("yfsAmount"));
    		value.put("ysfsAmount", m.get("ysfsAmount"));
    		value.put("jhAmount", m.get("jhAmount"));
    		value.put("amount", m.get("amount"));
    		resultMap.put(accId, value);
    	});
    	return resultMap;
    }
}
