package com.dst.slms.workBench.controller;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.supplierprofile.service.ISupplierClassificatioService;
import com.dst.slms.workBench.service.IFeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * @Title: 费控工作台
 * @Description: 门户页面
 * @author
 * @date 2019-07-01 14:22:48
 * @version V1.0
 *
 */
@Controller
@RequestMapping("/feeControl")
public class FeeControl extends CoreBaseController {
    @Autowired
    private IFeeService iFeeService;
    /**
     * 跳转首页
     * @param req  参数
     * @return modelAndView 跳转页面
     * @author wanghb
     * @date 2019-01-03
     */
    @ResponseBody
    @RequestMapping(value = "/index")
    public ModelAndView feeControl(HttpServletRequest req) {
        return new ModelAndView( "com/dst/slms/workBench/feeControl" );
    }


    /**
     * 数据初始化
     * @param req  参数
     * @return R 返回的数据
     * @author wanghb
     * @date 2019-01-03
     */
    @ResponseBody
    @RequestMapping(value = "/initData")
    public R initData(HttpServletRequest req) {
        String projectIds = UIRuleUtil.getString( req.getParameter( "projectIds" ) );
        R r = iFeeService.initData(projectIds);
        return r;
    }

    /**
     * 数据初始化
     * @param req  参数
     * @return R 返回的数据
     * @author wanghb
     * @date 2019-01-03
     */
    @ResponseBody
    @RequestMapping(value = "/initEcharts")
    public R initEcharts(HttpServletRequest req) {
        String projectIds = UIRuleUtil.getString( req.getParameter( "projectIds" ) );
        R r = iFeeService.initEcharts(projectIds);
        return r;
    }

    /**
     * 获取项目
     * @param req  参数
     * @return modelAndView 跳转页面
     * @author wanghb
     * @date 2019-01-03
     */
    @ResponseBody
    @RequestMapping(value = "/getMarketProject")
    public R getMarketProject(HttpServletRequest req) {
        R r = iFeeService.getMarketProject();
        return r;
    }


}
