package com.dst.slms.supplierreview.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.supplierreview.entity.ReviewTemplateInfo;
import com.dst.slms.supplierreview.service.IReviewTemplateService;

/**   
 * 评审模板 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 评审模板
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 *
 */
public abstract class AbstractReviewTemplateController extends CoreBaseController {

	@Autowired
	private IReviewTemplateService iReviewTemplateService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/supplierreview/reviewtemplate/reviewTemplateList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/supplierreview/reviewtemplate/reviewTemplateEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iReviewTemplateService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		ReviewTemplateInfo info = new ReviewTemplateInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		sic.add("reviewType.id");
		sic.add("reviewType.number");
		sic.add("reviewType.name");
		sic.add("isgCKC");
		sic.add("unitWeight.parent.id");
		sic.add("unitWeight.parent.number");
		sic.add("unitWeight.parent.name");
		sic.add("unitWeight.org.id");
		sic.add("unitWeight.org.number");
		sic.add("unitWeight.org.name");
		sic.add("unitWeight.weight");
		sic.add("templateChild.parent.id");
		sic.add("templateChild.parent.number");
		sic.add("templateChild.parent.name");
		sic.add("templateChild.guideName");
		sic.add("templateChild.fullNum");
		sic.add("templateChild.guideDescription");
		sic.add("templateChild.weight");
		sic.add("templateChild.remark");
		sic.add("templateChild.iskouF");
		sic.add("templateChild.org.id");
		sic.add("templateChild.org.number");
		sic.add("templateChild.org.name");
		return sic;
	}
	
	@RequiresPermissions("ree:reviewTemplate:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(ReviewTemplateInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("ree:reviewTemplate:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("ree:reviewTemplate:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("ree:reviewTemplate:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(ReviewTemplateInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("ree:reviewTemplate:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(ReviewTemplateInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("ree:reviewTemplate:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(ReviewTemplateInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("ree:reviewTemplate:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(ReviewTemplateInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("ree:reviewTemplate:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(ReviewTemplateInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("ree:reviewTemplate:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(ReviewTemplateInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
