package com.dst.slms.supplierprofile.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo;
import com.dst.slms.supplierprofile.service.ISupplyEvaluationService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 供应商评价 Controller
 * @Description: 供应商评价
 * @author 
 * @date 2020-05-02 14:59:27
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/supplyEvaluationController")
@SysPermissionName(name="供应商评价",type=Constant.MENU)
public class SupplyEvaluationController extends AbstractSupplyEvaluationController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SupplyEvaluationController.class);

	@Autowired
	private ISupplyEvaluationService iSupplyEvaluationService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(SupplyEvaluationInfo info, HttpServletRequest req) {
		return iSupplyEvaluationService.changeEnable(info,req);
	}
	
}
