package com.dst.slms.supplierprofile.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.service.util.ComboTreeValueModel;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.SpringContextUtils;
import com.dst.slms.common.utils.SysCaCheUtil;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo;
import com.dst.slms.supplierprofile.service.ISupplierClassificatioService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;

import com.alibaba.fastjson.JSONArray;
import com.dst.slms.common.RedisUtils;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 供应商分类 Controller
 * @Description: 供应商分类
 * @author 
 * @date 2020-05-02 14:59:27
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/supplierClassificatioController")
@SysPermissionName(name="供应商分类",type=Constant.MENU)
public class SupplierClassificatioController extends AbstractSupplierClassificatioController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SupplierClassificatioController.class);

	@Autowired
	private ISupplierClassificatioService iSupplierClassificatioService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(SupplierClassificatioInfo info, HttpServletRequest req) {
		return iSupplierClassificatioService.changeEnable(info,req);
	}
	
	/**
	 * 获取供应商分类信息树
	 */
	@ResponseBody
	@RequestMapping(value="/getListSupplierClassificatio")
	public List<ComboTreeValueModel> getListSupplierClassificatio(){
		EntityQuery eq=new EntityQuery(SupplierClassificatioInfo.class);
		eq.eq("isEnable", true);
		eq.add();
		List<SupplierClassificatioInfo> list=iSupplierClassificatioService.getEntityList(eq,new String []{"id","name"});
		List<ComboTreeValueModel> resultList = new ArrayList<>();
		resultList.add(new ComboTreeValueModel("-1", "供应商分类","000"));
		for (SupplierClassificatioInfo info : list) {
			resultList.add(new ComboTreeValueModel(UIRuleUtil.getString(info.getId()),UIRuleUtil.getString(info.getName()),"-1"));
		}
		return resultList;
	}
	/**
	 * 获取标签库
	 */
	@ResponseBody
	@RequestMapping(value="/getLabelTag")
	public JSONArray getLabelTag(){
		RedisUtils redisUtils = (RedisUtils) SpringContextUtils.getBean(RedisUtils.class);
		JSONArray dicArray = SysCaCheUtil.dicCaCheToJson(redisUtils, "LabelTag");
		return dicArray;
	}
	
}
