package com.dst.slms.supplierprofile.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 供应商档案 Info 对象
 * @Description: 供应商档案
 * @author 
 * @date 2020-05-03 11:03:28
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractSupplierProfileInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="公司名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="供应商编码" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="供应商考察评价" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierClassificatioID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商分类" )
	private com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo supplierClassificatio;
	
	@Column(name ="FsocialCreditNumber")
	@FieldMeta(name="统一社会信用代码" )
	private java.lang.String socialCreditNumber;
	
	@Column(name ="FenterpriseMaster")
	@FieldMeta(name="法人代表" )
	private java.lang.String enterpriseMaster;
	
	@Column(name ="FbuildDate")
	@FieldMeta(name="成立日期" )
	private java.util.Date buildDate;
	
	@Column(name ="FregisterMoney")
	@FieldMeta(name="注册资金(万元)" )
	private java.math.BigDecimal registerMoney;
	
	@Column(name ="Fcurrency")
	@FieldMeta(name="币别" ,enumGroupNumber="Currency")
	private java.lang.String currency;
	
	@Column(name ="FenterpriseKind")
	@FieldMeta(name="企业资质" ,enumGroupNumber="EnterpriseKind")
	private java.lang.String enterpriseKind;
	
	@Column(name ="FlinkPhone")
	@FieldMeta(name="公司电话" )
	private java.lang.String linkPhone;
	
	@Column(name ="Faddress")
	@FieldMeta(name="公司地址" )
	private java.lang.String address;
	
	@Column(name ="FwebSite")
	@FieldMeta(name="公司网站" )
	private java.lang.String webSite;
	
	@Column(name ="FlinkFax")
	@FieldMeta(name="公司传真" )
	private java.lang.String linkFax;
	
	@Column(name ="FmainWork")
	@FieldMeta(name="主营业务" )
	private java.lang.String mainWork;
	
	@Column(name ="Ftaxpayer")
	@FieldMeta(name="纳税人身份" ,enumGroupNumber="taxpayer")
	private java.lang.String taxpayer;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplyEvaluationID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商评价" )
	private com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo supplyEvaluation;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcityBaseID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="城市" )
	private com.dst.slms.system.entity.SysAreaInfo cityBase;
	
	@Column(name ="FlabelTag")
	@FieldMeta(name="标签" )
	private java.lang.String labelTag;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<SupplierLinkPersonInfo> supplierLinkPerson = new ArrayList<SupplierLinkPersonInfo>(); 

	public List<SupplierLinkPersonInfo> getSupplierLinkPerson() {
		return supplierLinkPerson;
	}

	public void setSupplierLinkPerson(List<SupplierLinkPersonInfo> supplierLinkPerson) {
		this.supplierLinkPerson = supplierLinkPerson;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<AptitudesFileInfo> aptitudesFile = new ArrayList<AptitudesFileInfo>(); 

	public List<AptitudesFileInfo> getAptitudesFile() {
		return aptitudesFile;
	}

	public void setAptitudesFile(List<AptitudesFileInfo> aptitudesFile) {
		this.aptitudesFile = aptitudesFile;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<SupplierLabelInfo> supplierLabel = new ArrayList<SupplierLabelInfo>(); 

	public List<SupplierLabelInfo> getSupplierLabel() {
		return supplierLabel;
	}

	public void setSupplierLabel(List<SupplierLabelInfo> supplierLabel) {
		this.supplierLabel = supplierLabel;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  公司名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  公司名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  供应商编码
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  供应商编码
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  供应商考察评价
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  供应商考察评价
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo  供应商分类
	 */
	public com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo getSupplierClassificatio(){
		return this.supplierClassificatio;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo  供应商分类
	 */
	public void setSupplierClassificatio(com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo supplierClassificatio){
		this.supplierClassificatio = supplierClassificatio;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  统一社会信用代码
	 */
	public java.lang.String getSocialCreditNumber(){
		return this.socialCreditNumber;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  统一社会信用代码
	 */
	public void setSocialCreditNumber(java.lang.String socialCreditNumber){
		this.socialCreditNumber = socialCreditNumber;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  法人代表
	 */
	public java.lang.String getEnterpriseMaster(){
		return this.enterpriseMaster;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  法人代表
	 */
	public void setEnterpriseMaster(java.lang.String enterpriseMaster){
		this.enterpriseMaster = enterpriseMaster;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  成立日期
	 */
	public java.util.Date getBuildDate(){
		return this.buildDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  成立日期
	 */
	public void setBuildDate(java.util.Date buildDate){
		this.buildDate = buildDate;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  注册资金(万元)
	 */
	public java.math.BigDecimal getRegisterMoney(){
		return this.registerMoney;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  注册资金(万元)
	 */
	public void setRegisterMoney(java.math.BigDecimal registerMoney){
		this.registerMoney = registerMoney;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  币别
	 */
	public java.lang.String getCurrency(){
		return this.currency;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  币别
	 */
	public void setCurrency(java.lang.String currency){
		this.currency = currency;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  企业资质
	 */
	public java.lang.String getEnterpriseKind(){
		return this.enterpriseKind;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  企业资质
	 */
	public void setEnterpriseKind(java.lang.String enterpriseKind){
		this.enterpriseKind = enterpriseKind;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  公司电话
	 */
	public java.lang.String getLinkPhone(){
		return this.linkPhone;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  公司电话
	 */
	public void setLinkPhone(java.lang.String linkPhone){
		this.linkPhone = linkPhone;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  公司地址
	 */
	public java.lang.String getAddress(){
		return this.address;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  公司地址
	 */
	public void setAddress(java.lang.String address){
		this.address = address;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  公司网站
	 */
	public java.lang.String getWebSite(){
		return this.webSite;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  公司网站
	 */
	public void setWebSite(java.lang.String webSite){
		this.webSite = webSite;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  公司传真
	 */
	public java.lang.String getLinkFax(){
		return this.linkFax;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  公司传真
	 */
	public void setLinkFax(java.lang.String linkFax){
		this.linkFax = linkFax;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  主营业务
	 */
	public java.lang.String getMainWork(){
		return this.mainWork;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  主营业务
	 */
	public void setMainWork(java.lang.String mainWork){
		this.mainWork = mainWork;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  纳税人身份
	 */
	public java.lang.String getTaxpayer(){
		return this.taxpayer;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  纳税人身份
	 */
	public void setTaxpayer(java.lang.String taxpayer){
		this.taxpayer = taxpayer;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo  供应商评价
	 */
	public com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo getSupplyEvaluation(){
		return this.supplyEvaluation;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo  供应商评价
	 */
	public void setSupplyEvaluation(com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo supplyEvaluation){
		this.supplyEvaluation = supplyEvaluation;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysAreaInfo
	 *@return: com.dst.slms.system.entity.SysAreaInfo  城市
	 */
	public com.dst.slms.system.entity.SysAreaInfo getCityBase(){
		return this.cityBase;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysAreaInfo
	 *@param: com.dst.slms.system.entity.SysAreaInfo  城市
	 */
	public void setCityBase(com.dst.slms.system.entity.SysAreaInfo cityBase){
		this.cityBase = cityBase;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  标签
	 */
	public java.lang.String getLabelTag(){
		return this.labelTag;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  标签
	 */
	public void setLabelTag(java.lang.String labelTag){
		this.labelTag = labelTag;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "ABV52IJP";
	}
}
