package com.dst.slms.plan.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.dst.slms.plan.entity.AnnualPaymentPlanInfo;
import com.dst.slms.plan.entity.ProjectYearBudgetInfo;
import com.dst.slms.plan.service.IProjectYearBudgetService;

/**   
 * @Title: 项目年度预算 ServiceImpl
 * @Description: 项目年度预算
 * @author 
 * @date 2020-05-02 11:14:38
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IProjectYearBudgetServiceImpl extends BillBaseCrudServiceImpl<ProjectYearBudgetInfo> implements IProjectYearBudgetService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IProjectYearBudgetServiceImpl.class);
	
	@Override
	protected R verifyInput(ProjectYearBudgetInfo entity) {
		StringBuffer sb = new StringBuffer();
		sb.append(" select fid from yc_cost_ProjectYearBudget ");
		sb.append(" where fid != '"+entity.getId()+"' and fnumber != '"+entity.getNumber()+"' and Fyear = '"+entity.getYear()+"' and FprojectID ='"+entity.getProject().getId()+"'");
		List<Map<String,Object>> ishave = executeSqlQuery(sb.toString());
		if(ishave.size()>0){
			throw new BizException("该项目"+entity.getYear()+"年已有项目年度预算，无法新增！");
		}
		return super.verifyInput(entity);
	}
}