package com.dst.slms.contractmange.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.contractmange.entity.PaymentReqInfo;
import com.dst.slms.contractmange.entity.SaleContractInfo;
import com.dst.slms.contractmange.service.IPaymentReqService;
import com.dst.slms.system.entity.SysOrgInfo;

import java.math.BigDecimal;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;

import com.alibaba.fastjson.JSONObject;
import com.dst.slms.base.entity.MarketProjectInfo;
import com.dst.slms.base.entity.TaxRateInfo;
import com.dst.slms.common.annotation.SysPermissionName;
import org.springframework.web.bind.annotation.PostMapping;
/**   
 * @Title: 付款申请单 Controller
 * @Description: 付款申请单
 * @author 
 * @date 2020-05-02 15:30:35
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/paymentReqController")
@SysPermissionName(name="付款申请单",type=Constant.MENU)
public class PaymentReqController extends AbstractPaymentReqController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(PaymentReqController.class);
	
	@Autowired
	private IPaymentReqService iPaymentReqService;
	
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("paq:paymentReq:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(PaymentReqInfo info, HttpServletRequest req) {
		return iPaymentReqService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("paq:paymentReq:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(PaymentReqInfo info, HttpServletRequest req) {
		return iPaymentReqService.unAudit(info.getId());
	}
	
	/**
	 * 根据合同获取营销项目和组织
	 */
	@ResponseBody
	@RequestMapping(value="/getOrg")
	public JSONObject getOrgUnit(HttpServletRequest request){
		String contractId = request.getParameter("contractId");
		JSONObject json = new JSONObject();
		if(UIRuleUtil.isNotNull(contractId)){
			SaleContractInfo contract = iPaymentReqService.getEntity(SaleContractInfo.class, contractId);
			SysOrgInfo admin = contract.getOrgunit();
			MarketProjectInfo project = contract.getProject();
			json.put("admin", admin);
			json.put("project", project);
		}
		return json;
	}
	/**
	 * 根据税率计算金额
	 */
	@ResponseBody
	@RequestMapping(value="/getAmt")
	public JSONObject getAmt(HttpServletRequest request){
		String rateId = UIRuleUtil.getString(request.getParameter("rateId"));
		BigDecimal taxReqAmt = UIRuleUtil.getBigDecimal(request.getParameter("taxReqAmt"));
		JSONObject json = new JSONObject();
		if(UIRuleUtil.isNotNull(rateId)){
			TaxRateInfo rateInfo = iPaymentReqService.getEntity(TaxRateInfo.class, rateId);
			BigDecimal rate = UIRuleUtil.getBigDecimal(rateInfo.getNumber());
			rate = rate.divide(new BigDecimal(100));
			BigDecimal taxAmt = taxReqAmt.multiply(rate);
			BigDecimal noTaxReqAmt = taxReqAmt.subtract(taxAmt);
			
			json.put("taxAmt", taxAmt);
			json.put("noTaxReqAmt", noTaxReqAmt);
		}
		return json;
	}
}
