package com.dst.slms.contractmange.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.HashMap;
import java.util.Map;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.contractmange.entity.ReceiptInfo;
import com.dst.slms.contractmange.service.IReceiptService;
import com.dst.slms.contractmange.service.ISaleContractService;
import com.dst.slms.proapproval.service.IMonMarkMangeService;

/**   
 * @Title: 验收单 ServiceImpl
 * @Description: 验收单
 * @author 
 * @date 2020-05-02 16:18:39
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IReceiptServiceImpl extends BillBaseCrudServiceImpl<ReceiptInfo> implements IReceiptService{
	@Autowired
	private ISaleContractService iSaleContractService;
	@Autowired
	private IReceiptService iReceiptService;
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IReceiptServiceImpl.class);
	@Override
	public R audit(String billId, String userId) {
		// TODO 自动生成的方法存根
		ReceiptInfo info = iReceiptService.getEntity(ReceiptInfo.class, billId);
		String sql="update yc_cost_saleContract set FisSettlement='Y',FsettlementAmt='"+UIRuleUtil.getBigDecimalValue(info.getYsAmt())+"' where fid ='"+info.getContract().getId()+"'";
		iSaleContractService.executeSql(sql);
		return super.audit(billId, userId);
	}
}