package com.dst.slms.base.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.base.entity.SigningInfoInfo;
import com.dst.slms.base.service.ISigningInfoService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 签约信息 Controller
 * @Description: 签约信息
 * @author 
 * @date 2020-05-02 10:08:28
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/signingInfoController")
@SysPermissionName(name="签约信息",type=Constant.MENU)
public class SigningInfoController extends AbstractSigningInfoController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SigningInfoController.class);

	@Autowired
	private ISigningInfoService iSigningInfoService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(SigningInfoInfo info, HttpServletRequest req) {
		return iSigningInfoService.changeEnable(info,req);
	}
	
	@Override
	protected boolean isIgnoreCUFilter() {
		return true;
	}
}
