dst.defineClass("com.dst.slms.workBench.cyclePaymentPlan", dst.framework.coreBillBaseList, {
	initalizeDOM:function(){
		com.dst.slms.workBench.cyclePaymentPlan.superClass.initalizeDOM.call(this);
		
		var zTree = $.fn.zTree.getZTreeObj("orgTree");            
	    var nodeList = zTree.getNodes();　　　　　　
	    zTree.expandNode(nodeList[0], true);
	    
	    var _self = this;
	    $('#editTreeGrid').datagrid({    
	        url:'datagrid_data.json',    
	        columns:[[    
	            {field:'code',title:'代码',width:100},    
	            {field:'name',title:'名称',width:100},    
	            {field:'price',title:'价格',width:100,align:'right'}    
	        ]]    
	    });  
	    $('#editTreeGrid').treegrid({
			url:'cyclePaymentPlanAccountData',    
		    idField:'id',    
		    treeField:'name',    
		    cls:'datagrid-simple',
			singleSelect:true,
			rownumbers:true,
			striped:true,
			fit:true,
			editorHeight:30,
			title:'项全盘-年度-月度计划实际对比',
			rowStyler: function(row,index){
				if(!row.isLeaf){
					return 'background-color:#cbcccd;';
				}
			},
			frozenColumns: [[  
                {title:'id',field:'id',hidden:true},    
                {field:'name',title:'科目名称',width:200},    
                {field:'number',title:'科目编码',width:140},    
            ]], 
		    columns:[
		    	[    
		    		{title:'项目全盘',colspan:5},    
		    		{title:'年度',colspan:4},    
		    		{title:'月度',colspan:4},    
		    	],
			    [    
			        {field:'planAmount',title:'计划发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'yfsAmount',title:'实际发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'ysfsAmount',title:'预算发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'jhAmount',title:'计划支付金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'amount',title:'实际支付金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        
			        {field:'yfsAmount1',title:'实际发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'ysfsAmount1',title:'预算发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'jhAmount1',title:'计划支付金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'amount1',title:'实际支付金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        
			        {field:'yfsAmount2',title:'实际发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'ysfsAmount2',title:'预算发生金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'jhAmount2',title:'计划支付金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			        {field:'amount2',title:'实际支付金额',width:120,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
			    ]
		    ],
		    onClickCell:function(field,row){
		    },
		    onLoadSuccess:function(data){
		    	_self.cacl_runAmount();
		    }
		});
	},
	cacl_runAmount:function(){
		var rows = $('#editTreeGrid').treegrid('getData');
		var row = null;
		for (var v = 0; v < rows.length; v++) {
			row = rows[v];
			this.calAmount(row);
		}
		if(row && row.children){
			var planAmount = 0;
			var yfsAmount = 0;
			var ysfsAmount = 0;
			var jhAmount = 0;
			var amount = 0;
			var yfsAmount1 = 0;
			var ysfsAmount1 = 0;
			var jhAmount1 = 0;
			var amount1 = 0;
			var yfsAmount2 = 0;
			var ysfsAmount2 = 0;
			var jhAmount2 = 0;
			var amount2 = 0;
			for (var o = 0; o < row.children.length; o++) {
				var ro = row.children[o];
				planAmount = Number(planAmount) + Number(ro.planAmount);
				yfsAmount = Number(yfsAmount) + Number(ro.yfsAmount);
				ysfsAmount = Number(ysfsAmount) + Number(ro.ysfsAmount);
				jhAmount = Number(jhAmount) + Number(ro.jhAmount);
				amount = Number(amount) + Number(ro.amount);
				yfsAmount1 = Number(yfsAmount1) + Number(ro.yfsAmount1);
				ysfsAmount1 = Number(ysfsAmount1) + Number(ro.ysfsAmount1);
				jhAmount1 = Number(jhAmount1) + Number(ro.jhAmount1);
				amount1 = Number(amount1) + Number(ro.amount1);
				yfsAmount2 = Number(yfsAmount2) + Number(ro.yfsAmount2);
				ysfsAmount2 = Number(ysfsAmount2) + Number(ro.ysfsAmount2);
				jhAmount2 = Number(jhAmount2) + Number(ro.jhAmount2);
				amount2 = Number(amount2) + Number(ro.amount2);
			}
			$('#editTreeGrid').treegrid('update',{id:row.id,row:{planAmount:planAmount,yfsAmount:yfsAmount,ysfsAmount:ysfsAmount,jhAmount:jhAmount,amount:amount,yfsAmount1:yfsAmount1,ysfsAmount1:ysfsAmount1,jhAmount1:jhAmount1,amount1:amount1,yfsAmount2:yfsAmount2,ysfsAmount2:ysfsAmount2,jhAmount2:jhAmount2,amount2:amount2}});
		}
	},
	calAmount:function(rows){
		for (var v = 0; v < rows.children.length; v++) {
			var row = rows.children[v];
			if(row.children){
				var planAmount = 0;
				var yfsAmount = 0;
				var ysfsAmount = 0;
				var jhAmount = 0; 
				var amount = 0;
				var yfsAmount1 = 0;
				var ysfsAmount1 = 0;
				var jhAmount1 = 0;
				var amount1 = 0;
				var yfsAmount2 = 0;
				var ysfsAmount2 = 0;
				var jhAmount2 = 0;
				var amount2 = 0;
				for (var o = 0; o < row.children.length; o++) {
					var ro = row.children[o]; 
					planAmount = Number(planAmount) + Number(ro.planAmount);
					yfsAmount = Number(yfsAmount) + Number(ro.yfsAmount);
					ysfsAmount = Number(ysfsAmount) + Number(ro.ysfsAmount);
					jhAmount = Number(jhAmount) + Number(ro.jhAmount);
					amount = Number(amount) + Number(ro.amount);
					yfsAmount1 = Number(yfsAmount1) + Number(ro.yfsAmount1);
					ysfsAmount1 = Number(ysfsAmount1) + Number(ro.ysfsAmount1);
					jhAmount1 = Number(jhAmount1) + Number(ro.jhAmount1);
					amount1 = Number(amount1) + Number(ro.amount1);
					yfsAmount2 = Number(yfsAmount2) + Number(ro.yfsAmount2);
					ysfsAmount2 = Number(ysfsAmount2) + Number(ro.ysfsAmount2);
					jhAmount2 = Number(jhAmount2) + Number(ro.jhAmount2);
					amount2 = Number(amount2) + Number(ro.amount2);
				}
				$('#editTreeGrid').treegrid('update',{id:row.id,row:{planAmount:planAmount,yfsAmount:yfsAmount,ysfsAmount:ysfsAmount,jhAmount:jhAmount,amount:amount,yfsAmount1:yfsAmount1,ysfsAmount1:ysfsAmount1,jhAmount1:jhAmount1,amount1:amount1,yfsAmount2:yfsAmount2,ysfsAmount2:ysfsAmount2,jhAmount2:jhAmount2,amount2:amount2}});
			}
		}
	},
	fmt_Amount:function(value){
		var number = Number(value);
    	if(isNaN(number)) {
    		return ''
    	}else{
    		var source = String(parseFloat(value).toFixed(2)).split(".");
    		source[0] = source[0].replace(new RegExp('(\\d)(?=(\\d{3})+$)','ig'),"$1,");
    		return source.join(".");
    	}
	},
	clickTreeAction:function(event, treeId, treeNode){
        $('#editTreeGrid').treegrid({
        	queryParams: {
        		projectId: treeNode.value,
        	}
        });
	},
});