dst.defineClass("com.dst.slms.plan.monthlypaymentplan.monthlyPaymentPlanEdit", dst.framework.coreBillBaseEdit, {
	initalizeDOM:function(){
		com.dst.slms.plan.monthlypaymentplan.monthlyPaymentPlanEdit.superClass.initalizeDOM.call(this);
		var _self = this;
		$('#year').combobox({onChange: function(newValue, oldValue){
			_self.refreshAction();
			_self.updateTitle();
		}});
		$('#month').combobox({onChange: function(newValue, oldValue){
			_self.refreshAction();
			_self.updateTitle();
		}});
		var billId = $('#id').val();
		$('#monthlyPaymentPlanE').treegrid({
			url:'getMonthlyPaymentPlanEByid?parentid='+billId,    
		    idField:'id',    
		    treeField:'name',    
		    cls:'datagrid-simple',
			singleSelect:true,
			rownumbers:true,
			striped:true,
			fit:true,
			editorHeight:30,
			title:'规划余额',
			rowStyler: function(row,index){
				if(!row.isLeaf){
					return 'background-color:#cbcccd;';
				}
			},
		    columns:[[    
		        {title:'id',field:'id',hidden:true},    
		        {field:'name',title:'科目名称',width:220},    
		        {field:'number',title:'科目编码',width:120},    
		        {field:'currentApplication',title:'本期申请（A）',width:100,align:'right',formatter:function(value,rec,index){
		        		return _self.fmt_Amount(value)
		        	}
		        },    
		        {field:'oldBalance',title:'上期结余（B）',width:100,align:'right',formatter:function(value,rec,index){
		        		return _self.fmt_Amount(value)
		        	}
		        },    
		        {field:'monthlyBalance',title:'当月预算（C）',width:100,align:'right',formatter:function(value,rec,index){
		        		return _self.fmt_Amount(value)
		        	}
		        },    
		        {field:'verifyabc',title:'校验（A-B-C）',width:100,align:'right',formatter:function(value,rec,index){
		        		 value = rec.currentApplication-rec.oldBalance-rec.monthlyBalance;
		        		 value = _self.fmt_Amount(value)
		        		 if(value<0){
		        			 return "<span style='color:red'>"+value+"</span>"
		        		 }else{
		        			 return value;
		        		 }
		        	}
		        },    
		    ]],
		    onLoadSuccess:function(data){
		    	_self.cacl_runAmount();
		    }
		});
		 var year = $("#year").combobox("getValue");
		 var month = $("#month").combobox("getValue");
		 var marketProjectId = $("#marketProject").textbox("getBizValue").id;
		if(!billId&&year&&month&&marketProjectId){
			_self.refreshAction();
		}
		setTimeout(function(){ _self.updateTitle()},100);
	},
	cacl_runAmount:function(){
		var rows = $('#monthlyPaymentPlanE').treegrid('getData');
		var row = null;
		for (var v = 0; v < rows.length; v++) {
			row = rows[v];
			this.calAmount(row);
		}
		if(row && row.children){
			var currentApplication = 0;
			var oldBalance = 0;
			var monthlyBalance = 0;
			var verifyabc = 0;
			for (var o = 0; o < row.children.length; o++) {
				var ro = row.children[o];
				currentApplication = Number(currentApplication) + Number(ro.currentApplication);
				oldBalance = Number(oldBalance) + Number(ro.oldBalance);
				monthlyBalance = Number(monthlyBalance) + Number(ro.monthlyBalance);
				verifyabc = Number(verifyabc) + Number(ro.verifyabc);
			}
			$('#monthlyPaymentPlanE').treegrid('update',{id:row.id,row:{currentApplication:currentApplication,oldBalance:oldBalance,monthlyBalance:monthlyBalance,verifyabc:verifyabc}});
		}
	},
	calAmount:function(rows){
		for (var v = 0; v < rows.children.length; v++) {
			var row = rows.children[v];
			if(row.children){
				var currentApplication = 0;
				var oldBalance = 0;
				var monthlyBalance = 0;
				var verifyabc = 0;
				for (var o = 0; o < row.children.length; o++) {
					var ro = row.children[o];
					currentApplication = Number(currentApplication) + Number(ro.currentApplication);
					oldBalance = Number(oldBalance) + Number(ro.oldBalance);
					monthlyBalance = Number(monthlyBalance) + Number(ro.monthlyBalance);
					verifyabc = Number(verifyabc) + Number(ro.verifyabc);
				}
				$('#monthlyPaymentPlanE').treegrid('update',{id:row.id,row:{currentApplication:currentApplication,oldBalance:oldBalance,monthlyBalance:monthlyBalance,verifyabc:verifyabc}});
			}
		}
	},
	fmt_Amount:function(value){
		var number = Number(value);
    	if(isNaN(number)) {
    		return ''
    	}else{
    		var source = String(parseFloat(value).toFixed(2)).split(".");
    		source[0] = source[0].replace(new RegExp('(\\d)(?=(\\d{3})+$)','ig'),"$1,");
    		return source.join(".");
    	}
	},
	updateMarketProject:function(newValue,oldValue){
		this.refreshAction();
	},
	refreshAction:function(){
		 var year = $("#year").combobox("getValue");
		 var month = $("#month").combobox("getValue");
		 var marketProjectId = $("#marketProject").textbox("getBizValue").id;
		if(year&&month&&marketProjectId){
			$('#signed-entity').datagrid({    
				queryParams:{
					newparentid:"-1",
					year:year,
					month:month,
					marketProjectId:marketProjectId
				}  
			}); 
			$('#expectedUnpaid-entity').datagrid({    
				queryParams:{
					newparentid:"-1",
					year:year,
					month:month,
					marketProjectId:marketProjectId
				}  
			}); 
			$('#monthlyPaymentPlanE').treegrid({    
				queryParams:{
					newparentid:"-1",
					year:year,
					month:month,
					marketProjectId:marketProjectId
				}  
			}); 
		}
	},
	verify: function() {
		if(this.gridEditId){
    		$('#monthlyPaymentPlanE').treegrid('endEdit',this.gridEditId);
    	}
		this.cacl_runAmount();
		var rows = $('#monthlyPaymentPlanE').treegrid('getData');
    	if($('#editTreeGrid_JSON').length==0){
    		$('#id').append('<input id="editTreeGrid_JSON" name="editTreeGrid_JSON" type="hidden">');
    	}
		$('#editTreeGrid_JSON').val(encodeURIComponent(JSON.stringify(rows)));
		return true;
	},
	updateTitle:function(){
		debugger;
		 var year = $("#year").combobox("getValue");
		 var month = $("#month").combobox("getValue");
		 if(year&&month){
			 year =  parseInt(year);
			 month =  parseInt(month);
			 var yeartwo=year;
			 var monthtwo=month+1;
			 if(monthtwo<10){
				 monthtwo="0"+monthtwo
			 }
			 if(monthtwo==13){
				 monthtwo="01";
				 yeartwo= yeartwo+1;
			 }
			 var yearthree=year;
			 var monththree=month+2;
			 if(monththree<10){
				 monththree="0"+monththree
			 }
			 if(monththree==13){
				 monththree="01";
				 yearthree= yearthree+1;
			 }
			 if(monththree==14){
				 monththree="02";
				 yearthree= yearthree+1;
			 }
			 if(month<10){
				 month="0"+month
			 }
			 $('#datagrid-td-group4-0-8').children("div").children("span").eq(0).text(year+"-"+month);
			 $('#datagrid-td-group4-0-9').children("div").children("span").eq(0).text(yeartwo+"-"+monthtwo);
			 $('#datagrid-td-group4-0-10').children("div").children("span").eq(0).text(yearthree+"-"+monththree);
		 }
	}
});