package com.dst.slms.supplierreview.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.supplierreview.entity.SupplierReviewInfo;
import com.dst.slms.supplierreview.entity.TemplateChildInfo;
import com.dst.slms.supplierreview.service.ISupplierReviewService;
/**   
 * @Title: 供应商评审 Controller
 * @Description: 供应商评审
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/supplierReviewController")
@SysPermissionName(name="供应商评审",type=Constant.MENU)
public class SupplierReviewController extends AbstractSupplierReviewController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SupplierReviewController.class);
	
	@Autowired
	private ISupplierReviewService iSupplierReviewService;
	
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("suw:supplierReview:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(SupplierReviewInfo info, HttpServletRequest req) {
		return iSupplierReviewService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("suw:supplierReview:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(SupplierReviewInfo info, HttpServletRequest req) {
		return iSupplierReviewService.unAudit(info.getId());
	}
	
	@Override
	public Object createNewModel(HttpServletRequest req) {
		SupplierReviewInfo info = (SupplierReviewInfo) super.createNewModel(req);
		info.setReviewDate(new Date());
		return info;
	}
	
	/**
	 * 获取评审模板
	 */
	@RequestMapping(value="/getReviewTemplate")
	@ResponseBody
	public List<Map<String,Object>> getReviewTemplate(HttpServletRequest request){
		String id = request.getParameter("id");
		List<TemplateChildInfo> list= iSupplierReviewService.getReviewTemplate(id);
		List<Map<String,Object>> relist=new ArrayList<Map<String,Object>>();
		if(list!=null&&list.size()>0){
			for (TemplateChildInfo templatechildinfo : list) {
				Map<String,Object> map=new HashMap<String,Object>();
				map.put("guideName",templatechildinfo.getGuideName());
				map.put("fullNum", templatechildinfo.getFullNum());
				map.put("weight", templatechildinfo.getWeight());
				map.put("remark", templatechildinfo.getGuideDescription());
				map.put("iskouF", templatechildinfo.getIskouF()?"true":"false");
				relist.add(map);
			}
		}
		return relist;
	}

}
