package com.dst.slms.supplierreview.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 评审模板分录 Info 对象
 * @Description: 评审模板分录
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractTemplateChildInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.supplierreview.entity.ReviewTemplateInfo parent;
	
	/**指标名称*/
	@Column(name ="FguideName")
	@FieldMeta(name="指标名称" )
	private java.lang.String guideName;
	
	/**标准*/
	@Column(name ="FfullNum")
	@FieldMeta(name="标准" )
	private java.lang.String fullNum;
	
	/**描述*/
	@Column(name ="FguideDescription")
	@FieldMeta(name="描述" )
	private java.lang.String guideDescription;
	
	/**权重%*/
	@Column(name ="Fweight")
	@FieldMeta(name="权重%" )
	private java.math.BigDecimal weight;
	
	/**说明*/
	@Column(name ="Fremark")
	@FieldMeta(name="说明" )
	private java.lang.String remark;
	
	/**是否扣分项*/
	@Column(name ="FiskouF")
	@FieldMeta(name="是否扣分项" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean iskouF;
	
	/**评审部门*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="评审部门" )
	private com.dst.slms.system.entity.SysOrgInfo org;
	
	
	/**
	 *方法: 取得com.dst.slms.supplierreview.entity.ReviewTemplateInfo
	 *@return: com.dst.slms.supplierreview.entity.ReviewTemplateInfo  父对象关联
	 */
	public com.dst.slms.supplierreview.entity.ReviewTemplateInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.supplierreview.entity.ReviewTemplateInfo
	 *@param: com.dst.slms.supplierreview.entity.ReviewTemplateInfo  父对象关联
	 */
	public void setParent(com.dst.slms.supplierreview.entity.ReviewTemplateInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  指标名称
	 */
	public java.lang.String getGuideName(){
		return this.guideName;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  指标名称
	 */
	public void setGuideName(java.lang.String guideName){
		this.guideName = guideName;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  标准
	 */
	public java.lang.String getFullNum(){
		return this.fullNum;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  标准
	 */
	public void setFullNum(java.lang.String fullNum){
		this.fullNum = fullNum;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  描述
	 */
	public java.lang.String getGuideDescription(){
		return this.guideDescription;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  描述
	 */
	public void setGuideDescription(java.lang.String guideDescription){
		this.guideDescription = guideDescription;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  权重%
	 */
	public java.math.BigDecimal getWeight(){
		return this.weight;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  权重%
	 */
	public void setWeight(java.math.BigDecimal weight){
		this.weight = weight;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemark(){
		return this.remark;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemark(java.lang.String remark){
		this.remark = remark;
	}
	
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否扣分项
	 */
	public boolean getIskouF(){
		return this.iskouF;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否扣分项
	 */
	public void setIskouF(boolean iskouF){
		this.iskouF = iskouF;
	}
	
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  评审部门
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrg(){
		return this.org;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  评审部门
	 */
	public void setOrg(com.dst.slms.system.entity.SysOrgInfo org){
		this.org = org;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "GIG6C49M";
	}
}
