package com.dst.slms.supplierprofile.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo;
import com.dst.slms.supplierprofile.service.ISupplierClassificatioService;

/**   
 * @Title: 供应商分类 ServiceImpl
 * @Description: 供应商分类
 * @author 
 * @date 2020-05-02 14:59:27
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ISupplierClassificatioServiceImpl extends CrudServiceImpl<SupplierClassificatioInfo> implements ISupplierClassificatioService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISupplierClassificatioServiceImpl.class);

	@Autowired
	private ISupplierClassificatioService iSupplierClassificatioService;
	
	public R changeEnable(SupplierClassificatioInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iSupplierClassificatioService.executeHql("update SupplierClassificatioInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}