package com.dst.slms.proapproval.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.proapproval.entity.ProjectApproveInfo;
import com.dst.slms.proapproval.service.IProjectApproveService;

/**   
 * 立项单 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 立项单
 * @author 
 * @date 2020-05-04 18:38:37
 * @version V1.0   
 *
 */
public abstract class AbstractProjectApproveController extends CoreBaseController {

	@Autowired
	private IProjectApproveService iProjectApproveService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/proapproval/projectapprove/projectApproveList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/proapproval/projectapprove/projectApproveEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iProjectApproveService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		ProjectApproveInfo info = new ProjectApproveInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("itemDes");
		sic.add("bizdate");
		sic.add("planType");
		sic.add("markaccount.id");
		sic.add("markaccount.number");
		sic.add("markaccount.name");
		sic.add("theme");
		sic.add("monMarkMange.id");
		sic.add("monMarkMange.number");
		sic.add("monMarkMange.name");
		sic.add("isoutplan");
		sic.add("ismonPay");
		sic.add("isglcontract");
		sic.add("istoContract");
		sic.add("lxAmt");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("contractNature");
		sic.add("orgunit.id");
		sic.add("orgunit.number");
		sic.add("orgunit.name");
		sic.add("supplier.id");
		sic.add("supplier.number");
		sic.add("supplier.name");
		sic.add("contract.id");
		sic.add("contract.number");
		sic.add("contract.name");
		sic.add("startNote");
		sic.add("monAmt");
		sic.add("purType");
		sic.add("isLast");
		sic.add("version");
		sic.add("proApp");
		return sic;
	}

	@RequiresPermissions("Pre:ProjectApprove:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(ProjectApproveInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("Pre:ProjectApprove:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("Pre:ProjectApprove:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("Pre:ProjectApprove:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(ProjectApproveInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("Pre:ProjectApprove:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(ProjectApproveInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("Pre:ProjectApprove:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(ProjectApproveInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("Pre:ProjectApprove:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(ProjectApproveInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("Pre:ProjectApprove:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(ProjectApproveInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("Pre:ProjectApprove:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(ProjectApproveInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
