package com.dst.slms.proapproval.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.common.utils.bos.BOSUuid;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.dst.slms.proapproval.entity.MonMarkMangeE1Info;
import com.dst.slms.proapproval.entity.ProjectApproveInfo;
import com.dst.slms.proapproval.service.IMonMarkMangeService;
import com.dst.slms.proapproval.service.IProjectApproveService;

/**   
 * @Title: 立项单 ServiceImpl
 * @Description: 立项单
 * @author 
 * @date 2020-05-02 15:30:44
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IProjectApproveServiceImpl extends BillBaseCrudServiceImpl<ProjectApproveInfo> implements IProjectApproveService{
	@Autowired
	private ICrudService iCrudService;
	@Autowired
	private IMonMarkMangeService iMonMarkMangeService;

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IProjectApproveServiceImpl.class);
	@Override
	public R audit(String billId, String userId) {
		// TODO 自动生成的方法存根
		ProjectApproveInfo info=(ProjectApproveInfo)iCrudService.getEntity(ProjectApproveInfo.class, billId);
		if(info.getVersion()==1){//第一版不需要将上一版本最新版改为fasle
			
		}else{//其他版本审批时需要将之前版本的最新版改为false
			info.setIsLast(true);
			SelectorItemCollection sic = new SelectorItemCollection();
			sic.add("isLast");
			iCrudService.save(info, sic);
			ProjectApproveInfo sourceinfo=(ProjectApproveInfo)iCrudService.getEntity(ProjectApproveInfo.class, info.getProApp(),  new String[]{"isLast","sourceBillId","version","proApp"});
			sourceinfo.setIsLast(false);
			iCrudService.save(sourceinfo, sic);
		}
		updatemon(info);
		return super.audit(billId, userId);
	}
	/**
	 * 有来源id的就去更新，没有来源id的就去新增
	 * 来源id是月计划的分录
	 */
	public void updatemon(ProjectApproveInfo info){
		String sourceBillId = info.getSourceBillId();
//		SelectorItemCollection sic = new SelectorItemCollection();
//		sic.add("parent.id");
//		sic.add("itemDes");
//		sic.add("planType");
//		sic.add("marketAccount.id");
//		sic.add("theme");
//		sic.add("isglcontract");
//		sic.add("planAmt");
//		sic.add("contractNature");
//		sic.add("supplier.id");
//		sic.add("contact.id");
//		sic.add("startNote");
//		sic.add("monAmt");
//		sic.add("purType");
//		sic.add("remark");
//		sic.add("id");
		MonMarkMangeE1Info monMarkMangeE1Info = new MonMarkMangeE1Info();
		boolean flag=false;//是否新增
		if("".equals(sourceBillId)||sourceBillId==null){//没有来源id，直接去新增
			sourceBillId=BOSUuid.create(monMarkMangeE1Info.getBosType());
			flag=true;
		}
		monMarkMangeE1Info.setId(sourceBillId);
		monMarkMangeE1Info.setParent(info.getMonMarkMange());
		monMarkMangeE1Info.setItemDes(info.getItemDes());
		monMarkMangeE1Info.setPlanType(info.getPlanType());
		monMarkMangeE1Info.setMarketAccount(info.getMarkaccount());
		monMarkMangeE1Info.setTheme(info.getTheme());
		monMarkMangeE1Info.setIsglcontract(info.getIsglcontract());
		monMarkMangeE1Info.setPlanAmt(info.getLxAmt());
		monMarkMangeE1Info.setContractNature(info.getContractNature());
		monMarkMangeE1Info.setSupplier(info.getSupplier());
		monMarkMangeE1Info.setContact(info.getContract());
		monMarkMangeE1Info.setStartNote(info.getStartNote());
		monMarkMangeE1Info.setMonAmt(info.getMonAmt());
		monMarkMangeE1Info.setPurType(info.getPurType());
		monMarkMangeE1Info.setRemark(info.getRemake());
//		if(flag){
//			iCrudService.addnew(monMarkMangeE1Info);
//		}else{
//			iCrudService.save(monMarkMangeE1Info, sic);
//		}
		iCrudService.save(monMarkMangeE1Info);

		String sql="update yc_cost_ProjectApprove set FSOURCEBILLID='"+sourceBillId+"' where fid ='"+info.getId()+"'";
		iCrudService.executeSql(sql);
	}
	@Override
	public R unAudit(String billId) {
		// TODO 自动生成的方法存根
		ProjectApproveInfo info=(ProjectApproveInfo)iCrudService.getEntity(ProjectApproveInfo.class, billId, new String[]{"isLast","sourceBillId","version","proApp"});
		if(info.getVersion()==1){
			return super.unAudit(billId);
		}else{
			SelectorItemCollection sic = new SelectorItemCollection();
			sic.add("isLast");
			info.setIsLast(false);
			iCrudService.save(info, sic);
			ProjectApproveInfo sourceinfo=(ProjectApproveInfo)iCrudService.getEntity(ProjectApproveInfo.class, info.getProApp(), new String[]{"isLast","sourceBillId","version","proApp"});
			sourceinfo.setIsLast(true);
			iCrudService.save(sourceinfo, sic);
			return super.unAudit(billId);
		}
	}

}