package com.dst.slms.plan.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.plan.entity.ProjectYearBudgetInfo;
import com.dst.slms.plan.service.IProjectYearBudgetService;

/**   
 * 项目年度预算 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 项目年度预算
 * @author 
 * @date 2020-05-05 09:18:06
 * @version V1.0   
 *
 */
public abstract class AbstractProjectYearBudgetController extends CoreBaseController {

	@Autowired
	private IProjectYearBudgetService iProjectYearBudgetService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/plan/projectyearbudget/projectYearBudgetList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/plan/projectyearbudget/projectYearBudgetEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iProjectYearBudgetService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		ProjectYearBudgetInfo info = new ProjectYearBudgetInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("org.id");
		sic.add("org.number");
		sic.add("org.name");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("year");
		sic.add("isnew");
		sic.add("editionnumber");
		sic.add("saleTarget");
		sic.add("rate");
		sic.add("projectYearBudgetE1.parent.id");
		sic.add("projectYearBudgetE1.parent.number");
		sic.add("projectYearBudgetE1.parent.name");
		sic.add("projectYearBudgetE1.account.id");
		sic.add("projectYearBudgetE1.account.number");
		sic.add("projectYearBudgetE1.account.name");
		sic.add("projectYearBudgetE1.accountName");
		sic.add("projectYearBudgetE1.amount");
		sic.add("projectYearBudgetE1.one");
		sic.add("projectYearBudgetE1.two");
		sic.add("projectYearBudgetE1.three");
		sic.add("projectYearBudgetE1.four");
		sic.add("projectYearBudgetE1.five");
		sic.add("projectYearBudgetE1.six");
		sic.add("projectYearBudgetE1.seven");
		sic.add("projectYearBudgetE1.eight");
		sic.add("projectYearBudgetE1.nine");
		sic.add("projectYearBudgetE1.ten");
		sic.add("projectYearBudgetE1.eleven");
		sic.add("projectYearBudgetE1.twelve");
		return sic;
	}

	@RequiresPermissions("Prt:ProjectYearBudget:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(ProjectYearBudgetInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("Prt:ProjectYearBudget:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("Prt:ProjectYearBudget:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("Prt:ProjectYearBudget:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(ProjectYearBudgetInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("Prt:ProjectYearBudget:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(ProjectYearBudgetInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("Prt:ProjectYearBudget:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(ProjectYearBudgetInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("Prt:ProjectYearBudget:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(ProjectYearBudgetInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("Prt:ProjectYearBudget:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(ProjectYearBudgetInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("Prt:ProjectYearBudget:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(ProjectYearBudgetInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
