package com.dst.slms.plan.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.contractmange.entity.EconTermsAdjustE1Info;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.dst.slms.plan.entity.CyclePaymentPlanE2Info;
import com.dst.slms.plan.entity.CyclePaymentPlanInfo;
import com.dst.slms.plan.service.ICyclePaymentPlanService;

/**   
 * @Title: 项目全周期费用规划 ServiceImpl
 * @Description: 项目全周期费用规划
 * @author 
 * @date 2020-05-02 11:14:38
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ICyclePaymentPlanServiceImpl extends BillBaseCrudServiceImpl<CyclePaymentPlanInfo> implements ICyclePaymentPlanService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ICyclePaymentPlanServiceImpl.class);
	
	
	@Override
	protected R verifyInput(CyclePaymentPlanInfo entity) {
		
		StringBuffer sb = new StringBuffer();
		sb.append(" select fid from yc_cost_CyclePaymentPlan ");
		sb.append(" where fid != '"+entity.getId()+"' and fnumber != '"+entity.getNumber()+"' and FprojectID ='"+entity.getProject().getId()+"'");
		List<Map<String,Object>> ishave = executeSqlQuery(sb.toString());
		if(ishave.size()>0){
			throw new BizException("该项目已有项目全周期费用规划，无法新增！");
		}
		
		BigDecimal tolRate = BigDecimal.ZERO;
		for (int i = 0; i < entity.getCyclePaymentPlanE2().size(); i++) {
			CyclePaymentPlanE2Info e2Info = entity.getCyclePaymentPlanE2().get(i);
			BigDecimal rate = UIRuleUtil.getBigDecimal(e2Info.getPlanAmountRate());
			tolRate = tolRate.add(rate);
		}
		if(tolRate.compareTo(new BigDecimal(100))!=0){
			throw new BizException("预算年度拆解规划金额百分比合计不等于100%，无法保存");
		}
		
		return super.verifyInput(entity);
	}
}