package com.dst.slms.plan.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 费用明细 Info 对象
 * @Description: 费用明细
 * @author 
 * @date 2020-05-04 17:39:29
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractCyclePaymentPlanE1Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.plan.entity.CyclePaymentPlanInfo parent;
	
	/**费用科目*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarketAccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="费用科目" )
	private com.dst.slms.base.entity.MarketAccountInfo marketAccount;
	
	/**科目编码*/
	@Column(name ="FaccountNumber")
	@FieldMeta(name="科目编码" )
	private java.lang.String accountNumber;
	
	/**规划金额*/
	@Column(name ="FplanAmount")
	@FieldMeta(name="规划金额" )
	private java.math.BigDecimal planAmount;
	
	/**占比*/
	@Column(name ="Frate")
	@FieldMeta(name="占比" )
	private java.math.BigDecimal rate;
	
	/**已发生金额*/
	@Column(name ="FyfsAmount")
	@FieldMeta(name="已发生金额" )
	private java.math.BigDecimal yfsAmount;
	
	/**规划余额*/
	@Column(name ="FplanYe")
	@FieldMeta(name="规划余额" )
	private java.math.BigDecimal planYe;
	
	/**已支付*/
	@Column(name ="FpayAmount")
	@FieldMeta(name="已支付" )
	private java.math.BigDecimal payAmount;
	
	/**说明*/
	@Column(name ="Fremarks")
	@FieldMeta(name="说明" )
	private java.lang.String remarks;
	
	
	/**
	 *方法: 取得com.dst.slms.plan.entity.CyclePaymentPlanInfo
	 *@return: com.dst.slms.plan.entity.CyclePaymentPlanInfo  父对象关联
	 */
	public com.dst.slms.plan.entity.CyclePaymentPlanInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.plan.entity.CyclePaymentPlanInfo
	 *@param: com.dst.slms.plan.entity.CyclePaymentPlanInfo  父对象关联
	 */
	public void setParent(com.dst.slms.plan.entity.CyclePaymentPlanInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  费用科目
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarketAccount(){
		return this.marketAccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  费用科目
	 */
	public void setMarketAccount(com.dst.slms.base.entity.MarketAccountInfo marketAccount){
		this.marketAccount = marketAccount;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  科目编码
	 */
	public java.lang.String getAccountNumber(){
		return this.accountNumber;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  科目编码
	 */
	public void setAccountNumber(java.lang.String accountNumber){
		this.accountNumber = accountNumber;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  规划金额
	 */
	public java.math.BigDecimal getPlanAmount(){
		return this.planAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  规划金额
	 */
	public void setPlanAmount(java.math.BigDecimal planAmount){
		this.planAmount = planAmount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  占比
	 */
	public java.math.BigDecimal getRate(){
		return this.rate;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  占比
	 */
	public void setRate(java.math.BigDecimal rate){
		this.rate = rate;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  已发生金额
	 */
	public java.math.BigDecimal getYfsAmount(){
		return this.yfsAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  已发生金额
	 */
	public void setYfsAmount(java.math.BigDecimal yfsAmount){
		this.yfsAmount = yfsAmount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  规划余额
	 */
	public java.math.BigDecimal getPlanYe(){
		return this.planYe;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  规划余额
	 */
	public void setPlanYe(java.math.BigDecimal planYe){
		this.planYe = planYe;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  已支付
	 */
	public java.math.BigDecimal getPayAmount(){
		return this.payAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  已支付
	 */
	public void setPayAmount(java.math.BigDecimal payAmount){
		this.payAmount = payAmount;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemarks(){
		return this.remarks;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemarks(java.lang.String remarks){
		this.remarks = remarks;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "6SJNS00S";
	}
}
