package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 费用明细页签 Info 对象
 * @Description: 费用明细页签
 * @author 
 * @date 2020-05-04 14:11:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractReceiptE3Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.ReceiptInfo parent;
	
	/**费用科目*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarkAccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="费用科目" )
	private com.dst.slms.base.entity.MarketAccountInfo markAccount;
	
	/**合同拆分(万元)*/
	@Column(name ="FconAmt")
	@FieldMeta(name="合同拆分(万元)" )
	private java.math.BigDecimal conAmt;
	
	/**本次验收金额*/
	@Column(name ="FysAmt")
	@FieldMeta(name="本次验收金额" )
	private java.math.BigDecimal ysAmt;
	
	/**营销活动内容*/
	@Column(name ="Fcomment")
	@FieldMeta(name="营销活动内容" )
	private java.lang.String comment;
	
	/**来访人数*/
	@Column(name ="Flfcount")
	@FieldMeta(name="来访人数" )
	private java.lang.Integer lfcount;
	
	/**成交套数*/
	@Column(name ="Fcjcount")
	@FieldMeta(name="成交套数" )
	private java.lang.Integer cjcount;
	
	/**成交金额*/
	@Column(name ="FcjAmt")
	@FieldMeta(name="成交金额" )
	private java.math.BigDecimal cjAmt;
	
	/**说明*/
	@Column(name ="Fremark")
	@FieldMeta(name="说明" )
	private java.lang.String remark;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.ReceiptInfo
	 *@return: com.dst.slms.contractmange.entity.ReceiptInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.ReceiptInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.ReceiptInfo
	 *@param: com.dst.slms.contractmange.entity.ReceiptInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.ReceiptInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  费用科目
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarkAccount(){
		return this.markAccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  费用科目
	 */
	public void setMarkAccount(com.dst.slms.base.entity.MarketAccountInfo markAccount){
		this.markAccount = markAccount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  合同拆分(万元)
	 */
	public java.math.BigDecimal getConAmt(){
		return this.conAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  合同拆分(万元)
	 */
	public void setConAmt(java.math.BigDecimal conAmt){
		this.conAmt = conAmt;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  本次验收金额
	 */
	public java.math.BigDecimal getYsAmt(){
		return this.ysAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  本次验收金额
	 */
	public void setYsAmt(java.math.BigDecimal ysAmt){
		this.ysAmt = ysAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  营销活动内容
	 */
	public java.lang.String getComment(){
		return this.comment;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  营销活动内容
	 */
	public void setComment(java.lang.String comment){
		this.comment = comment;
	}
	
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  来访人数
	 */
	public java.lang.Integer getLfcount(){
		return this.lfcount;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  来访人数
	 */
	public void setLfcount(java.lang.Integer lfcount){
		this.lfcount = lfcount;
	}
	
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  成交套数
	 */
	public java.lang.Integer getCjcount(){
		return this.cjcount;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  成交套数
	 */
	public void setCjcount(java.lang.Integer cjcount){
		this.cjcount = cjcount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  成交金额
	 */
	public java.math.BigDecimal getCjAmt(){
		return this.cjAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  成交金额
	 */
	public void setCjAmt(java.math.BigDecimal cjAmt){
		this.cjAmt = cjAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemark(){
		return this.remark;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemark(java.lang.String remark){
		this.remark = remark;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "MWWJMFX5";
	}
}
