package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.SalesProgressInfo;
import com.dst.slms.base.service.ISalesProgressService;

/**   
 * @Title: 销售进度 ServiceImpl
 * @Description: 销售进度
 * @author 
 * @date 2020-05-07 10:39:17
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ISalesProgressServiceImpl extends CrudServiceImpl<SalesProgressInfo> implements ISalesProgressService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISalesProgressServiceImpl.class);

	@Autowired
	private ISalesProgressService iSalesProgressService;
	
	public R changeEnable(SalesProgressInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iSalesProgressService.executeHql("update SalesProgressInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}