package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.service.util.ComboTreeValueModel;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.support.TreeCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.MarketAccountInfo;
import com.dst.slms.base.service.IMarketAccountService;

/**   
 * @Title: 营销科目 ServiceImpl
 * @Description: 营销科目
 * @author 
 * @date 2020-05-02 10:08:28
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IMarketAccountServiceImpl extends TreeCrudServiceImpl<MarketAccountInfo> implements IMarketAccountService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IMarketAccountServiceImpl.class);

	@Autowired
	private IMarketAccountService iMarketAccountService;
	
	public R changeEnable(MarketAccountInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iMarketAccountService.executeHql("update MarketAccountInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
	
	/**
	 * 动态加载树形结构
	 * @return
	 */
	@Override
	public List getAccountTreeData(HttpServletRequest request) {
		//是否要显示禁用的组织
		StringBuilder filter = new StringBuilder(UIRuleUtil.isNull(request.getParameter("isShowAll"))?"":" and isEnable='Y'");
//		filter.append(UIRuleUtil.isNull(request.getParameter("isHR")) ? "" : " and isHR='"+request.getParameter("isHR")+"'");
		List<ComboTreeValueModel> treeData = new ArrayList<ComboTreeValueModel>();
		List list = iMarketAccountService.findByQueryString("select id,name,parent.id,level from MarketAccountInfo ");
		for (int i = 0; i <list.size(); i++) {
			Object obj[] = (Object[]) list.get(i);
			String id = UIRuleUtil.getString(obj[0]);
			String name = UIRuleUtil.getString(obj[1]);
			String parentId = UIRuleUtil.getString(obj[2]);
			treeData.add(new ComboTreeValueModel(id,name,parentId));
		}
		treeData.add(new ComboTreeValueModel("","营销科目",""));
		return treeData;
	}
}