package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.ContractTypeInfo;
import com.dst.slms.base.service.IContractTypeService;

/**   
 * @Title: 合同类型 ServiceImpl
 * @Description: 合同类型
 * @author 
 * @date 2020-05-02 15:33:16
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IContractTypeServiceImpl extends CrudServiceImpl<ContractTypeInfo> implements IContractTypeService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IContractTypeServiceImpl.class);

	@Autowired
	private IContractTypeService iContractTypeService;
	
	public R changeEnable(ContractTypeInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iContractTypeService.executeHql("update ContractTypeInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}