package com.dst.slms.supplierreview.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.supplierreview.entity.ReviewTypeInfo;
import com.dst.slms.supplierreview.service.IReviewTypeService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 评审类型 Controller
 * @Description: 评审类型
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/reviewTypeController")
@SysPermissionName(name="评审类型",type=Constant.MENU)
public class ReviewTypeController extends AbstractReviewTypeController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ReviewTypeController.class);

	@Autowired
	private IReviewTypeService iReviewTypeService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(ReviewTypeInfo info, HttpServletRequest req) {
		return iReviewTypeService.changeEnable(info,req);
	}
	
}
