package com.dst.slms.supplierprofile.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.supplierprofile.entity.SupplierProfileInfo;
import com.dst.slms.supplierprofile.service.ISupplierProfileService;

/**   
 * 供应商档案 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 供应商档案
 * @author 
 * @date 2020-05-03 11:03:28
 * @version V1.0   
 *
 */
public abstract class AbstractSupplierProfileController extends CoreBaseController {

	@Autowired
	private ISupplierProfileService iSupplierProfileService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/supplierprofile/supplierprofile/supplierProfileList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/supplierprofile/supplierprofile/supplierProfileEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSupplierProfileService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SupplierProfileInfo info = new SupplierProfileInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("supplierClassificatio.id");
		sic.add("supplierClassificatio.number");
		sic.add("supplierClassificatio.name");
		sic.add("socialCreditNumber");
		sic.add("enterpriseMaster");
		sic.add("buildDate");
		sic.add("registerMoney");
		sic.add("currency");
		sic.add("enterpriseKind");
		sic.add("linkPhone");
		sic.add("address");
		sic.add("webSite");
		sic.add("linkFax");
		sic.add("mainWork");
		sic.add("taxpayer");
		sic.add("supplyEvaluation.id");
		sic.add("supplyEvaluation.number");
		sic.add("supplyEvaluation.name");
		sic.add("cityBase.id");
		sic.add("cityBase.number");
		sic.add("cityBase.name");
		sic.add("labelTag");
		sic.add("supplierLinkPerson.parent.id");
		sic.add("supplierLinkPerson.parent.number");
		sic.add("supplierLinkPerson.parent.name");
		sic.add("supplierLinkPerson.personName");
		sic.add("supplierLinkPerson.position");
		sic.add("supplierLinkPerson.phone");
		sic.add("supplierLinkPerson.workPhone");
		sic.add("supplierLinkPerson.personFax");
		sic.add("supplierLinkPerson.Isdefault");
		sic.add("supplierLinkPerson.email");
		sic.add("aptitudesFile.parent.id");
		sic.add("aptitudesFile.parent.number");
		sic.add("aptitudesFile.parent.name");
		sic.add("aptitudesFile.aptNumber");
		sic.add("aptitudesFile.aptName");
		sic.add("aptitudesFile.aptLevel");
		sic.add("aptitudesFile.endDate");
		sic.add("aptitudesFile.awardUnit");
		sic.add("aptitudesFile.remark");
		sic.add("supplierLabel.parent.id");
		sic.add("supplierLabel.parent.number");
		sic.add("supplierLabel.parent.name");
		sic.add("supplierLabel.supplierClassificatio.id");
		sic.add("supplierLabel.supplierClassificatio.number");
		sic.add("supplierLabel.supplierClassificatio.name");
		return sic;
	}

	@RequiresPermissions("sue:supplierProfile:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SupplierProfileInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("sue:supplierProfile:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("sue:supplierProfile:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("sue:supplierProfile:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SupplierProfileInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("sue:supplierProfile:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SupplierProfileInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("sue:supplierProfile:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SupplierProfileInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("sue:supplierProfile:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SupplierProfileInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("sue:supplierProfile:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SupplierProfileInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("sue:supplierProfile:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(SupplierProfileInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
