package com.dst.slms.proapproval.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 营销计划 Info 对象
 * @Description: 营销计划
 * @author 
 * @date 2020-05-05 08:27:14
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractMonMarkMangeE1Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.proapproval.entity.MonMarkMangeInfo parent;
	
	/**主题*/
	@Column(name ="Ftheme")
	@FieldMeta(name="主题" )
	private java.lang.String theme;
	
	/**主题描述*/
	@Column(name ="FthemeDes")
	@FieldMeta(name="主题描述" )
	private java.lang.String themeDes;
	
	/**主题计划金额*/
	@Column(name ="FthemeAmt")
	@FieldMeta(name="主题计划金额" )
	private java.math.BigDecimal themeAmt;
	
	/**计划类型*/
	@Column(name ="FplanType")
	@FieldMeta(name="计划类型" ,enumGroupNumber="planType")
	private java.lang.String planType;
	
	/**事项描述*/
	@Column(name ="FitemDes")
	@FieldMeta(name="事项描述" )
	private java.lang.String itemDes;
	
	/**营销科目*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarketAccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="营销科目" )
	private com.dst.slms.base.entity.MarketAccountInfo marketAccount;
	
	/**事项状态*/
	@Column(name ="FitemStatus")
	@FieldMeta(name="事项状态" ,enumGroupNumber="itemStatus")
	private java.lang.String itemStatus;
	
	/**采购方式*/
	@Column(name ="FpurType")
	@FieldMeta(name="采购方式" ,enumGroupNumber="purType")
	private java.lang.String purType;
	
	/**合同性质*/
	@Column(name ="FcontractNature")
	@FieldMeta(name="合同性质" ,enumGroupNumber="contractNature")
	private java.lang.String contractNature;
	
	/**合同编号*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontactID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同编号" )
	private com.dst.slms.contractmange.entity.SaleContractInfo contact;
	
	/**是否关联框架合同*/
	@Column(name ="Fisglcontract")
	@FieldMeta(name="是否关联框架合同" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isglcontract;
	
	/**供应商*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier;
	
	/**计划金额*/
	@Column(name ="FplanAmt")
	@FieldMeta(name="计划金额" )
	private java.math.BigDecimal planAmt;
	
	/**当月使用金额*/
	@Column(name ="FmonAmt")
	@FieldMeta(name="当月使用金额" )
	private java.math.BigDecimal monAmt;
	
	/**已支付金额*/
	@Column(name ="FpayAmt")
	@FieldMeta(name="已支付金额" )
	private java.math.BigDecimal payAmt;
	
	/**开始节点*/
	@Column(name ="FstartNote")
	@FieldMeta(name="开始节点" ,enumGroupNumber="startNote")
	private java.lang.String startNote;
	
	/**备注*/
	@Column(name ="Fremark")
	@FieldMeta(name="备注" )
	private java.lang.String remark;
	
	
	/**
	 *方法: 取得com.dst.slms.proapproval.entity.MonMarkMangeInfo
	 *@return: com.dst.slms.proapproval.entity.MonMarkMangeInfo  父对象关联
	 */
	public com.dst.slms.proapproval.entity.MonMarkMangeInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.proapproval.entity.MonMarkMangeInfo
	 *@param: com.dst.slms.proapproval.entity.MonMarkMangeInfo  父对象关联
	 */
	public void setParent(com.dst.slms.proapproval.entity.MonMarkMangeInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  主题
	 */
	public java.lang.String getTheme(){
		return this.theme;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  主题
	 */
	public void setTheme(java.lang.String theme){
		this.theme = theme;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  主题描述
	 */
	public java.lang.String getThemeDes(){
		return this.themeDes;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  主题描述
	 */
	public void setThemeDes(java.lang.String themeDes){
		this.themeDes = themeDes;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  主题计划金额
	 */
	public java.math.BigDecimal getThemeAmt(){
		return this.themeAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  主题计划金额
	 */
	public void setThemeAmt(java.math.BigDecimal themeAmt){
		this.themeAmt = themeAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  计划类型
	 */
	public java.lang.String getPlanType(){
		return this.planType;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  计划类型
	 */
	public void setPlanType(java.lang.String planType){
		this.planType = planType;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  事项描述
	 */
	public java.lang.String getItemDes(){
		return this.itemDes;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  事项描述
	 */
	public void setItemDes(java.lang.String itemDes){
		this.itemDes = itemDes;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarketAccount(){
		return this.marketAccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public void setMarketAccount(com.dst.slms.base.entity.MarketAccountInfo marketAccount){
		this.marketAccount = marketAccount;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  事项状态
	 */
	public java.lang.String getItemStatus(){
		return this.itemStatus;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  事项状态
	 */
	public void setItemStatus(java.lang.String itemStatus){
		this.itemStatus = itemStatus;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  采购方式
	 */
	public java.lang.String getPurType(){
		return this.purType;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  采购方式
	 */
	public void setPurType(java.lang.String purType){
		this.purType = purType;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同性质
	 */
	public java.lang.String getContractNature(){
		return this.contractNature;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同性质
	 */
	public void setContractNature(java.lang.String contractNature){
		this.contractNature = contractNature;
	}
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同编号
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getContact(){
		return this.contact;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同编号
	 */
	public void setContact(com.dst.slms.contractmange.entity.SaleContractInfo contact){
		this.contact = contact;
	}
	
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否关联框架合同
	 */
	public boolean getIsglcontract(){
		return this.isglcontract;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否关联框架合同
	 */
	public void setIsglcontract(boolean isglcontract){
		this.isglcontract = isglcontract;
	}
	
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplier(){
		return this.supplier;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public void setSupplier(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier){
		this.supplier = supplier;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  计划金额
	 */
	public java.math.BigDecimal getPlanAmt(){
		return this.planAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  计划金额
	 */
	public void setPlanAmt(java.math.BigDecimal planAmt){
		this.planAmt = planAmt;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  当月使用金额
	 */
	public java.math.BigDecimal getMonAmt(){
		return this.monAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  当月使用金额
	 */
	public void setMonAmt(java.math.BigDecimal monAmt){
		this.monAmt = monAmt;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  已支付金额
	 */
	public java.math.BigDecimal getPayAmt(){
		return this.payAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  已支付金额
	 */
	public void setPayAmt(java.math.BigDecimal payAmt){
		this.payAmt = payAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  开始节点
	 */
	public java.lang.String getStartNote(){
		return this.startNote;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  开始节点
	 */
	public void setStartNote(java.lang.String startNote){
		this.startNote = startNote;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemark(){
		return this.remark;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemark(java.lang.String remark){
		this.remark = remark;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "1M0ETU5W";
	}
}
