package com.dst.slms.plan.service;

import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.support.IBillBaseCrudService;
import com.dst.slms.common.utils.R;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.dst.slms.plan.entity.MonthlyPaymentPlanInfo;

/**   
 * @Title: 月度支付计划 Service
 * @Description: 月度支付计划
 * @author 
 * @date 2020-05-02 16:24:33
 * @version V1.0   
 */
public interface IMonthlyPaymentPlanService extends IBillBaseCrudService<MonthlyPaymentPlanInfo>{
	
	/**
	 * 获取已签约数据
	 * @param response
	 * @param request
	 * @param dataGrid
	 * @return
	 */
	Object getSignedByid(HttpServletResponse response, HttpServletRequest request, DataGrid dataGrid);
	
	/**
	 * 获取逾期未支付
	 * @param response
	 * @param request
	 * @param dataGrid
	 * @return
	 */
	Object getExpectedUnpaidByid(HttpServletResponse response, HttpServletRequest request, DataGrid dataGrid);

}
