package com.dst.slms.plan.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 已签约 Info 对象
 * @Description: 已签约
 * @author 
 * @date 2020-05-04 18:55:28
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractSignedInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.plan.entity.MonthlyPaymentPlanInfo parent;
	
	/**合同编码*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsaleContractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同编码" )
	private com.dst.slms.contractmange.entity.SaleContractInfo saleContract;
	
	/**合同名称*/
	@Column(name ="FsaleContractName")
	@FieldMeta(name="合同名称" )
	private java.lang.String saleContractName;
	
	/**供应商*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierProfileID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplierProfile;
	
	/**营销科目*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarketAccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="营销科目" )
	private com.dst.slms.base.entity.MarketAccountInfo marketAccount;
	
	/**合同金额*/
	@Column(name ="FcontractAmount")
	@FieldMeta(name="合同金额" )
	private java.math.BigDecimal contractAmount;
	
	/**已付金额*/
	@Column(name ="FamountPaid")
	@FieldMeta(name="已付金额" )
	private java.math.BigDecimal amountPaid;
	
	/**未付金额*/
	@Column(name ="FunpaidAmount")
	@FieldMeta(name="未付金额" )
	private java.math.BigDecimal unpaidAmount;
	
	/**月份1*/
	@Column(name ="FoneMonth")
	@FieldMeta(name="月份1" )
	private java.math.BigDecimal monthOne;
	
	/**月份2*/
	@Column(name ="FmonthTwo")
	@FieldMeta(name="月份2" )
	private java.math.BigDecimal monthTwo;
	
	/**月份3*/
	@Column(name ="FmonthThree")
	@FieldMeta(name="月份3" )
	private java.math.BigDecimal monthThree;
	
	
	/**
	 *方法: 取得com.dst.slms.plan.entity.MonthlyPaymentPlanInfo
	 *@return: com.dst.slms.plan.entity.MonthlyPaymentPlanInfo  父对象关联
	 */
	public com.dst.slms.plan.entity.MonthlyPaymentPlanInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.plan.entity.MonthlyPaymentPlanInfo
	 *@param: com.dst.slms.plan.entity.MonthlyPaymentPlanInfo  父对象关联
	 */
	public void setParent(com.dst.slms.plan.entity.MonthlyPaymentPlanInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同编码
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getSaleContract(){
		return this.saleContract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同编码
	 */
	public void setSaleContract(com.dst.slms.contractmange.entity.SaleContractInfo saleContract){
		this.saleContract = saleContract;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同名称
	 */
	public java.lang.String getSaleContractName(){
		return this.saleContractName;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同名称
	 */
	public void setSaleContractName(java.lang.String saleContractName){
		this.saleContractName = saleContractName;
	}
	
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplierProfile(){
		return this.supplierProfile;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public void setSupplierProfile(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplierProfile){
		this.supplierProfile = supplierProfile;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarketAccount(){
		return this.marketAccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public void setMarketAccount(com.dst.slms.base.entity.MarketAccountInfo marketAccount){
		this.marketAccount = marketAccount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  合同金额
	 */
	public java.math.BigDecimal getContractAmount(){
		return this.contractAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  合同金额
	 */
	public void setContractAmount(java.math.BigDecimal contractAmount){
		this.contractAmount = contractAmount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  已付金额
	 */
	public java.math.BigDecimal getAmountPaid(){
		return this.amountPaid;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  已付金额
	 */
	public void setAmountPaid(java.math.BigDecimal amountPaid){
		this.amountPaid = amountPaid;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  未付金额
	 */
	public java.math.BigDecimal getUnpaidAmount(){
		return this.unpaidAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  未付金额
	 */
	public void setUnpaidAmount(java.math.BigDecimal unpaidAmount){
		this.unpaidAmount = unpaidAmount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  月份1
	 */
	public java.math.BigDecimal getMonthOne(){
		return this.monthOne;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  月份1
	 */
	public void setMonthOne(java.math.BigDecimal monthOne){
		this.monthOne = monthOne;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  月份2
	 */
	public java.math.BigDecimal getMonthTwo(){
		return this.monthTwo;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  月份2
	 */
	public void setMonthTwo(java.math.BigDecimal monthTwo){
		this.monthTwo = monthTwo;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  月份3
	 */
	public java.math.BigDecimal getMonthThree(){
		return this.monthThree;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  月份3
	 */
	public void setMonthThree(java.math.BigDecimal monthThree){
		this.monthThree = monthThree;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "UJINO9YX";
	}
}
