package com.dst.slms.plan.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 项目全周期费用规划 Info 对象
 * @Description: 项目全周期费用规划
 * @author 
 * @date 2020-05-04 17:39:29
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractCyclePaymentPlanInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@Column(name ="FsaleTarget")
	@FieldMeta(name="销售目标" )
	private java.math.BigDecimal saleTarget;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpersonID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="提交人" )
	private com.dst.slms.system.entity.SysPersonInfo person;
	
	@Column(name ="Fbudget")
	@FieldMeta(name="预算金额" )
	private java.math.BigDecimal budget;
	
	@Column(name ="Frate")
	@FieldMeta(name="费率%" )
	private java.math.BigDecimal rate;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@Column(name ="Fisnew")
	@FieldMeta(name="是否最新版" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isnew;
	
	@Column(name ="Feditionnumber")
	@FieldMeta(name="版本号" )
	private java.lang.Integer editionnumber;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<CyclePaymentPlanE1Info> cyclePaymentPlanE1 = new ArrayList<CyclePaymentPlanE1Info>(); 

	public List<CyclePaymentPlanE1Info> getCyclePaymentPlanE1() {
		return cyclePaymentPlanE1;
	}

	public void setCyclePaymentPlanE1(List<CyclePaymentPlanE1Info> CyclePaymentPlanE1) {
		this.cyclePaymentPlanE1 = CyclePaymentPlanE1;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<CyclePaymentPlanE2Info> cyclePaymentPlanE2 = new ArrayList<CyclePaymentPlanE2Info>(); 

	public List<CyclePaymentPlanE2Info> getCyclePaymentPlanE2() {
		return cyclePaymentPlanE2;
	}

	public void setCyclePaymentPlanE2(List<CyclePaymentPlanE2Info> CyclePaymentPlanE2) {
		this.cyclePaymentPlanE2 = CyclePaymentPlanE2;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  销售目标
	 */
	public java.math.BigDecimal getSaleTarget(){
		return this.saleTarget;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  销售目标
	 */
	public void setSaleTarget(java.math.BigDecimal saleTarget){
		this.saleTarget = saleTarget;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysPersonInfo
	 *@return: com.dst.slms.system.entity.SysPersonInfo  提交人
	 */
	public com.dst.slms.system.entity.SysPersonInfo getPerson(){
		return this.person;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysPersonInfo
	 *@param: com.dst.slms.system.entity.SysPersonInfo  提交人
	 */
	public void setPerson(com.dst.slms.system.entity.SysPersonInfo person){
		this.person = person;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  预算金额
	 */
	public java.math.BigDecimal getBudget(){
		return this.budget;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  预算金额
	 */
	public void setBudget(java.math.BigDecimal budget){
		this.budget = budget;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  费率%
	 */
	public java.math.BigDecimal getRate(){
		return this.rate;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  费率%
	 */
	public void setRate(java.math.BigDecimal rate){
		this.rate = rate;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否最新版
	 */
	public boolean getIsnew(){
		return this.isnew;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否最新版
	 */
	public void setIsnew(boolean isnew){
		this.isnew = isnew;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  版本号
	 */
	public java.lang.Integer getEditionnumber(){
		return this.editionnumber;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  版本号
	 */
	public void setEditionnumber(java.lang.Integer editionnumber){
		this.editionnumber = editionnumber;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "9EXIPM7C";
	}
}
