package com.dst.slms.contractmange.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.contractmange.entity.ReceiptInfo;
import com.dst.slms.contractmange.service.IReceiptService;

/**   
 * 验收单 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 验收单
 * @author 
 * @date 2020-05-04 14:11:42
 * @version V1.0   
 *
 */
public abstract class AbstractReceiptController extends CoreBaseController {

	@Autowired
	private IReceiptService iReceiptService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/contractmange/receipt/receiptList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/contractmange/receipt/receiptEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iReceiptService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		ReceiptInfo info = new ReceiptInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("reqPerson.id");
		sic.add("reqPerson.number");
		sic.add("reqPerson.name");
		sic.add("reqDate");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("execution");
		sic.add("contract.id");
		sic.add("contract.number");
		sic.add("contract.name");
		sic.add("contractNum");
		sic.add("conDate");
		sic.add("conAmt");
		sic.add("partA.id");
		sic.add("partA.number");
		sic.add("partA.name");
		sic.add("supplier.id");
		sic.add("supplier.number");
		sic.add("supplier.name");
		sic.add("kjcontract.id");
		sic.add("kjcontract.number");
		sic.add("kjcontract.name");
		sic.add("contractType.id");
		sic.add("contractType.number");
		sic.add("contractType.name");
		sic.add("sjphone");
		sic.add("sjperson");
		sic.add("ysAmt");
		sic.add("score");
		sic.add("result");
		sic.add("receiptE3.parent.id");
		sic.add("receiptE3.parent.number");
		sic.add("receiptE3.parent.name");
		sic.add("receiptE3.markAccount.id");
		sic.add("receiptE3.markAccount.number");
		sic.add("receiptE3.markAccount.name");
		sic.add("receiptE3.conAmt");
		sic.add("receiptE3.ysAmt");
		sic.add("receiptE3.comment");
		sic.add("receiptE3.lfcount");
		sic.add("receiptE3.cjcount");
		sic.add("receiptE3.cjAmt");
		sic.add("receiptE3.remark");
		sic.add("receiptE1.parent.id");
		sic.add("receiptE1.parent.number");
		sic.add("receiptE1.parent.name");
		sic.add("receiptE1.evaluation");
		sic.add("receiptE1.score");
		sic.add("receiptE1.weight");
		sic.add("receiptE1.remark");
		sic.add("receiptE2.parent.id");
		sic.add("receiptE2.parent.number");
		sic.add("receiptE2.parent.name");
		sic.add("receiptE2.name");
		sic.add("receiptE2.MTDL");
		sic.add("receiptE2.MTXL.id");
		sic.add("receiptE2.MTXL.number");
		sic.add("receiptE2.MTXL.name");
		sic.add("receiptE2.startDate");
		sic.add("receiptE2.endDate");
		sic.add("receiptE2.tfAmt");
		sic.add("receiptE2.remark");
		return sic;
	}

	@RequiresPermissions("ret:receipt:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(ReceiptInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("ret:receipt:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("ret:receipt:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("ret:receipt:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(ReceiptInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("ret:receipt:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(ReceiptInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("ret:receipt:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(ReceiptInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("ret:receipt:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(ReceiptInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("ret:receipt:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(ReceiptInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("ret:receipt:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(ReceiptInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
