package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 营销合同税款明细 Info 对象
 * @Description: 营销合同税款明细
 * @author 
 * @date 2020-05-02 17:43:18
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractSaleContractTaxEInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.SaleContractInfo parent;
	
	/**明细内容*/
	@Column(name ="Fcontent")
	@FieldMeta(name="明细内容" )
	private java.lang.String content;
	
	/**含税金额*/
	@Column(name ="FtaxConAmt")
	@FieldMeta(name="含税金额" )
	private java.math.BigDecimal taxConAmt;
	
	/**税率(%)*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FtaxRateID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="税率(%)" )
	private com.dst.slms.base.entity.TaxRateInfo taxRate;
	
	/**不含税金额*/
	@Column(name ="FnoTaxConAmt")
	@FieldMeta(name="不含税金额" )
	private java.math.BigDecimal noTaxConAmt;
	
	/**进项税额*/
	@Column(name ="FtaxAmt")
	@FieldMeta(name="进项税额" )
	private java.math.BigDecimal taxAmt;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.SaleContractInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  明细内容
	 */
	public java.lang.String getContent(){
		return this.content;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  明细内容
	 */
	public void setContent(java.lang.String content){
		this.content = content;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  含税金额
	 */
	public java.math.BigDecimal getTaxConAmt(){
		return this.taxConAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  含税金额
	 */
	public void setTaxConAmt(java.math.BigDecimal taxConAmt){
		this.taxConAmt = taxConAmt;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.TaxRateInfo
	 *@return: com.dst.slms.base.entity.TaxRateInfo  税率(%)
	 */
	public com.dst.slms.base.entity.TaxRateInfo getTaxRate(){
		return this.taxRate;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.TaxRateInfo
	 *@param: com.dst.slms.base.entity.TaxRateInfo  税率(%)
	 */
	public void setTaxRate(com.dst.slms.base.entity.TaxRateInfo taxRate){
		this.taxRate = taxRate;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  不含税金额
	 */
	public java.math.BigDecimal getNoTaxConAmt(){
		return this.noTaxConAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  不含税金额
	 */
	public void setNoTaxConAmt(java.math.BigDecimal noTaxConAmt){
		this.noTaxConAmt = noTaxConAmt;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  进项税额
	 */
	public java.math.BigDecimal getTaxAmt(){
		return this.taxAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  进项税额
	 */
	public void setTaxAmt(java.math.BigDecimal taxAmt){
		this.taxAmt = taxAmt;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "AQG8IVEJ";
	}
}
