package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 评估指标 Info 对象
 * @Description: 评估指标
 * @author 
 * @date 2020-05-04 14:11:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractReceiptE1Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.ReceiptInfo parent;
	
	/**评估指标*/
	@Column(name ="Fevaluation")
	@FieldMeta(name="评估指标" ,enumGroupNumber="evaluation")
	private java.lang.String evaluation;
	
	/**评分(100分制)*/
	@Column(name ="Fscore")
	@FieldMeta(name="评分(100分制)" )
	private java.lang.Integer score;
	
	/**权重*/
	@Column(name ="Fweight")
	@FieldMeta(name="权重" )
	private java.lang.Integer weight;
	
	/**说明*/
	@Column(name ="Fremark")
	@FieldMeta(name="说明" )
	private java.lang.String remark;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.ReceiptInfo
	 *@return: com.dst.slms.contractmange.entity.ReceiptInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.ReceiptInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.ReceiptInfo
	 *@param: com.dst.slms.contractmange.entity.ReceiptInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.ReceiptInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  评估指标
	 */
	public java.lang.String getEvaluation(){
		return this.evaluation;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  评估指标
	 */
	public void setEvaluation(java.lang.String evaluation){
		this.evaluation = evaluation;
	}
	
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  评分(100分制)
	 */
	public java.lang.Integer getScore(){
		return this.score;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  评分(100分制)
	 */
	public void setScore(java.lang.Integer score){
		this.score = score;
	}
	
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  权重
	 */
	public java.lang.Integer getWeight(){
		return this.weight;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  权重
	 */
	public void setWeight(java.lang.Integer weight){
		this.weight = weight;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemark(){
		return this.remark;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemark(java.lang.String remark){
		this.remark = remark;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "CL0BO6JA";
	}
}
