package com.dst.slms.contractmange.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 经济条款调整单 Info 对象
 * @Description: 经济条款调整单
 * @author 
 * @date 2020-05-03 14:57:21
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractEconTermsAdjustInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同信息" )
	private com.dst.slms.contractmange.entity.SaleContractInfo contract;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="责任部门" )
	private com.dst.slms.system.entity.SysOrgInfo org;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier;
	
	@Column(name ="FconAmount")
	@FieldMeta(name="合同金额" )
	private java.math.BigDecimal conAmount;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<EconTermsAdjustE1Info> econTermsAdjustE1 = new ArrayList<EconTermsAdjustE1Info>(); 

	public List<EconTermsAdjustE1Info> getEconTermsAdjustE1() {
		return econTermsAdjustE1;
	}

	public void setEconTermsAdjustE1(List<EconTermsAdjustE1Info> EconTermsAdjustE1) {
		this.econTermsAdjustE1 = EconTermsAdjustE1;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同信息
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getContract(){
		return this.contract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同信息
	 */
	public void setContract(com.dst.slms.contractmange.entity.SaleContractInfo contract){
		this.contract = contract;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  责任部门
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrg(){
		return this.org;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  责任部门
	 */
	public void setOrg(com.dst.slms.system.entity.SysOrgInfo org){
		this.org = org;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplier(){
		return this.supplier;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public void setSupplier(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier){
		this.supplier = supplier;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  合同金额
	 */
	public java.math.BigDecimal getConAmount(){
		return this.conAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  合同金额
	 */
	public void setConAmount(java.math.BigDecimal conAmount){
		this.conAmount = conAmount;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "HXOQG0AN";
	}
}
